package cn.com.duiba.tuia.risk.engine.api.req;

/**
 * 提供给兑吧的接口入参
 * <p>
 * consumer_id：必传
 * 兑吧场景标识：必传，1 访问；2活动参与；3奖励；4兑换；5 提现
 * 场景标识：必传,由风控提供
 * 活动长ID：：选传，没有时为空即可
 * 活动短ID：：选传，没有时为空即可
 * 活动类型：必传
 * 支付宝账号：提现场景下必填
 * 支付宝姓名：提现场景下必填
 * 位置信息：选传，没有时为空即可
 * 设备id：必传
 * IP地址：必传
 * UA：必传
 * 设备类型：IOS、Android、H5，必传
 * 请求时间：yyyy-mm-dd hh：mm：ss，必传
 * 系统来源(source)必传：目前支持 推啊广告(tuia-advert),趣闻(news),兑吧(duiba)
 */
public class DuiBaRuleEngineParam extends RuleEngineParam {

    private static final long serialVersionUID = 660742843130929620L;

    //活动短ID
    private Long activityId;
    //活动短ID
    private Long activityShortId;
    //活动类型
    private Integer activityType;
    //支付宝账号
    private String aliPayAccount;
    //支付宝姓名
    private String aliPayName;
    //位置信息
    private String position;
    //兑吧风控验证场景标识
    private Integer duibaScene;

    //商品id
    private Long itemId;
    //被助力用户id
    private Long assistedUserId;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getActivityShortId() {
        return activityShortId;
    }

    public void setActivityShortId(Long activityShortId) {
        this.activityShortId = activityShortId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getAliPayAccount() {
        return aliPayAccount;
    }

    public void setAliPayAccount(String aliPayAccount) {
        this.aliPayAccount = aliPayAccount;
    }

    public String getAliPayName() {
        return aliPayName;
    }

    public void setAliPayName(String aliPayName) {
        this.aliPayName = aliPayName;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public Integer getDuibaScene() {
        return duibaScene;
    }

    public void setDuibaScene(Integer duibaScene) {
        this.duibaScene = duibaScene;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getAssistedUserId() {
        return assistedUserId;
    }

    public void setAssistedUserId(Long assistedUserId) {
        this.assistedUserId = assistedUserId;
    }
}
