package cn.com.duiba.tuia.risk.engine.api.req;


import java.io.Serializable;
import java.util.Date;


/**
 * RuleEngine Param
 * <p>
 * consumer_id：必传
 * 手机号：选传，没有时为空即可
 * 场景标识：必传
 * 媒体id：选传，没有时为空即可
 * 广告位id：选传，没有时为空即可
 * 设备id：必传
 * IP地址：必传
 * UA：必传
 * 设备类型(platform)：IOS、Android、H5，必传
 * APP版本号：选传
 * 请求时间：yyyy-mm-dd hh：mm：ss，必传
 * 系统来源(source)必传：目前支持 推啊广告(tuia-advert),趣闻(news),兑吧(duiba)
 */
public class RuleEngineParam implements Serializable {

    private static final long serialVersionUID = -3694008580925855051L;

    private String riskOrderId;

    //广告订单id
    private String advertOrderId;

    //用户id
    private String consumerId;

    //设备id
    private String deviceId;

    //场景标识
    private String sceneKey;

    //ip
    private String ip;

    //ua
    private String ua;

    //设备类型(platform)：IOS、Android、H5，必传
    private String platform;

    //请求时间：yyyy-mm-dd hh：mm：ss，必传
    private Date date;

    //媒体id
    private String mediaId;

    //广告位id
    private String soltId;

    //手机号：选传，没有时为空即可
    private String phone;

    //APP版本号：选传
    private String appVersion;

    //系统来源(source)必传：目前支持 推啊广告(tuia-advert),趣闻(news),兑吧(duiba)
    private String source;

    //rid
    private String rid;

    //uuid6
    private String uuid6;


    private String imei;
    private String imeiMd5;

    private String idfa;
    private String idfaMd5;

    private String oaid;
    private String oaidMd5;

    private String aliPayId;

    public String getRiskOrderId() {
        return riskOrderId;
    }

    public void setRiskOrderId(String riskOrderId) {
        this.riskOrderId = riskOrderId;
    }

    public String getAdvertOrderId() {
        return advertOrderId;
    }

    public void setAdvertOrderId(String advertOrderId) {
        this.advertOrderId = advertOrderId;
    }

    public String getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getSceneKey() {
        return sceneKey;
    }

    public void setSceneKey(String sceneKey) {
        this.sceneKey = sceneKey;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getMediaId() {
        return mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getSoltId() {
        return soltId;
    }

    public void setSoltId(String soltId) {
        this.soltId = soltId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAppVersion() {
        return appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public String getUuid6() {
        return uuid6;
    }

    public void setUuid6(String uuid6) {
        this.uuid6 = uuid6;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getImeiMd5() {
        return imeiMd5;
    }

    public void setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getIdfaMd5() {
        return idfaMd5;
    }

    public void setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
    }

    public String getOaid() {
        return oaid;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public String getOaidMd5() {
        return oaidMd5;
    }

    public void setOaidMd5(String oaidMd5) {
        this.oaidMd5 = oaidMd5;
    }

    public String getAliPayId() {
        return aliPayId;
    }

    public void setAliPayId(String aliPayId) {
        this.aliPayId = aliPayId;
    }
}
