package cn.com.duiba.tuia.risk.engine.api.rsp.ov;

import cn.com.duiba.tuia.risk.center.api.constant.RuleAction;

import java.io.Serializable;
import java.util.List;

public class Rule implements Serializable {

    private static final long serialVersionUID = 3351768274761484365L;

    private Long id;

    private transient String name;

    private Long strategyId;

    private Long parentRuleId;

    private Integer type;

    private Integer mode;

    private Integer status;

    private Integer hitStatus;

    private Double decision;

    private RuleAction ruleAction;

    /**
     * 拓展关联维度:1-rid,2-uuid6,3-deviceId,4-ua,5-ip
     */
    private Integer relateType;

    private List<Condition> conditionList;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    public Long getParentRuleId() {
        return parentRuleId;
    }

    public void setParentRuleId(Long parentRuleId) {
        this.parentRuleId = parentRuleId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getMode() {
        return mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public Double getDecision() {
        return decision;
    }

    public void setDecision(Double decision) {
        this.decision = decision;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public RuleAction getRuleAction() {
        return ruleAction;
    }

    public void setRuleAction(RuleAction ruleAction) {
        this.ruleAction = ruleAction;
    }

    public List<Condition> getConditionList() {
        return conditionList;
    }

    public void setConditionList(List<Condition> conditionList) {
        this.conditionList = conditionList;
    }

    public Integer getHitStatus() {
        return hitStatus;
    }

    public void setHitStatus(Integer hitStatus) {
        this.hitStatus = hitStatus;
    }

    public Integer getRelateType() {
        return relateType;
    }

    public void setRelateType(Integer relateType) {
        this.relateType = relateType;
    }

    @Override
    public String toString() {
        return "Rule{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", strategyId=" + strategyId +
                ", parentRuleId=" + parentRuleId +
                ", type=" + type +
                ", mode=" + mode +
                ", status=" + status +
                ", hitStatus=" + hitStatus +
                ", decision=" + decision +
                ", ruleAction=" + ruleAction +
                ", relateType=" + relateType +
                ", conditionList=" + conditionList +
                '}';
    }
}
