package cn.com.duiba.tuia.risk.engine.api.remote;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.risk.engine.api.exception.LimitRateException;
import cn.com.duiba.tuia.risk.engine.api.req.DuiBaRuleEngineParam;
import cn.com.duiba.tuia.risk.engine.api.req.RuleEngineParam;
import cn.com.duiba.tuia.risk.engine.api.rsp.RuleEngineResult;

@AdvancedFeignClient
public interface RemoteRuleEngineService {

    // 保证实时接口响应时间不超过100ms
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "150")
    RuleEngineResult operator(RuleEngineParam param);

    RuleEngineResult operatorOffline(RuleEngineParam param) throws LimitRateException;

    RuleEngineResult tryOperator(RuleEngineParam param, boolean isDebug);

    RuleEngineResult operator4Quwen(RuleEngineParam param);

    RuleEngineResult operator4Duiba(DuiBaRuleEngineParam param);

}
