package cn.com.duiba.tuia.risk.engine.api.rsp;

import java.io.Serializable;

public class RuleEngineResult implements Serializable {

    private static final long serialVersionUID = -2195935373556252331L;

    public static final RuleEngineResult HIT_STAGE = new RuleEngineResult();

    public static final RuleEngineResult NOT_HIT_STAGE = new RuleEngineResult();

    static {
        HIT_STAGE.setReject(true);
        NOT_HIT_STAGE.setReject(false);
    }

    private boolean reject;

    private boolean success = true;

    private int rank;

    private String desc;

    public int getRank() {
        return rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    private ResultDetail resultDetail;

    public boolean isReject() {
        return reject;
    }

    public void setReject(boolean reject) {
        this.reject = reject;
    }

    public ResultDetail getResultDetail() {
        return resultDetail;
    }

    public void setResultDetail(ResultDetail resultDetail) {
        this.resultDetail = resultDetail;
    }

    public static RuleEngineResult getBadParamStage(String desc) {
        RuleEngineResult badParamStage = new RuleEngineResult();
        badParamStage.setReject(false);
        badParamStage.setSuccess(false);
        badParamStage.setRank(0);
        badParamStage.setDesc(desc);
        return badParamStage;
    }
}
