package cn.com.duiba.tuia.robot.center.api.domain.dto;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

@JsonIgnoreProperties({"handler", "fieldHandler"})
@Data
public class BaseEntity implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId
    @ApiModelProperty(
            value = "唯一标识",
            hidden = true
    )
    private String id;
    @TableField(
            fill = FieldFill.INSERT
    )
    @ApiModelProperty(
            value = "创建者",
            hidden = true
    )
    private String createBy;
    @JsonFormat(
            timezone = "GMT+8",
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @TableField(
            fill = FieldFill.INSERT
    )
    @ApiModelProperty(
            value = "创建时间",
            hidden = true
    )
    private Date gmtCreate;

    @JsonFormat(
            timezone = "GMT+8",
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @TableField(
            fill = FieldFill.INSERT_UPDATE
    )
    @ApiModelProperty(
            value = "更新时间",
            hidden = true
    )
    private Date gmtModify;
    @TableField(
            fill = FieldFill.INSERT
    )
    @ApiModelProperty(
            value = "删除标志 true/false 删除/未删除",
            hidden = true
    )
    private Boolean deleteFlag;
}
