package cn.com.duiba.tuia.robot.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.robot.center.api.domain.dos.AdminUser;
import cn.com.duiba.tuia.robot.center.api.domain.dto.AdminUserDTO;
import cn.com.duiba.tuia.robot.center.api.domain.dto.Token;
import cn.com.duiba.tuia.robot.center.api.domain.enums.UserEnums;
import cn.com.duiba.tuia.robot.center.api.domain.vo.AdminUserVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 管理员接口
 */
@AdvancedFeignClient
public interface RemoteAdminUserService {
    /**
     * 分页查询管理员列表
     * @return
     */
    Page<AdminUserVO> page(Page<AdminUser> initPage, QueryWrapper<AdminUser> initWrapper);

    /**
     * 通过用户名获取用户
     *
     * @param username
     * @return
     */
    AdminUser findByUsername(String username);


    AdminUser findById(String id);


    /**
     * 更新管理员
     *
     * @param adminUser
     * @param roles
     * @return
     */
    boolean updateAdminUser(AdminUser adminUser, List<String> roles);


    /**
     * 修改管理员密码
     *
     * @param password
     * @param newPassword
     */
    void editPassword(String password, String newPassword);

    /**
     * 重置密码
     *
     * @param ids id集合
     */
    void resetPassword(List<String> ids);

    /**
     * 新增管理员
     *
     * @param adminUser
     * @param roles
     */
    void saveAdminUser(AdminUserDTO adminUser, List<String> roles);

    /**
     * 彻底删除
     *
     * @param ids
     */
//    void deleteCompletely(List<String> ids);


    /**
     * 用户登录
     *
     * @param username 用户名
     * @param password 密码
     * @return token
     */
    Token login(String username, String password);

    /**
     * 刷新token
     *
     * @param refreshToken
     * @return token
     */
    Token refreshToken(String refreshToken);

    /**
     * 登出
     *
     * @param userEnums token角色类型
     */
    void logout(UserEnums userEnums);

    List<AdminUser> all(String username,Integer adminType);

    List<AdminUserDTO> find(List<String> ids);
}
