package cn.com.duiba.tuia.robot.center.api.domain.vo;

import cn.com.duiba.tuia.robot.center.api.domain.dos.Menu;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@Data
public class MenuVO extends Menu {

    @ApiModelProperty(value = "子菜单")
    private List<MenuVO> children = new ArrayList<>();

    public MenuVO() {

    }

    public MenuVO(Menu menu) {
        BeanUtils.copyProperties(menu, this);
    }

    public List<MenuVO> getChildren() {
        if (children != null) {
            children.sort(new Comparator<MenuVO>() {
                @Override
                public int compare(MenuVO o1, MenuVO o2) {
                    return o1.getSortOrder().compareTo(o2.getSortOrder());
                }
            });
            return children;
        }
        return null;
    }
}