package cn.com.duiba.tuia.robot.center.api.domain.vo;

import cn.com.duiba.tuia.robot.center.api.domain.utils.StringUtils;
import cn.hutool.core.text.CharSequenceUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
@Data
public class PageVO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("页号")
    private Integer pageNumber = 1;
    @ApiModelProperty("页面大小")
    private Integer pageSize = 10;
    @ApiModelProperty("排序字段")
    private String sort;
    @ApiModelProperty("排序方式 asc/desc")
    private String order;
    @ApiModelProperty(
            value = "需要驼峰转换蛇形",
            notes = "一般不做处理，如果数据库中就是蛇形，则这块需要处理。"
    )
    private Boolean notConvert;

    public String getSort() {
        if (!CharSequenceUtil.isEmpty(this.sort)) {
            return this.notConvert != null && !Boolean.FALSE.equals(this.notConvert) ? this.sort : StringUtils.camel2Underline(this.sort);
        } else {
            return this.sort;
        }
    }

    public PageVO() {
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getOrder() {
        return this.order;
    }

    public Boolean getNotConvert() {
        return this.notConvert;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void setNotConvert(Boolean notConvert) {
        this.notConvert = notConvert;
    }




}
