package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.constant.SlotShieldConstant;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.URL;

import java.util.*;
import java.util.stream.Collectors;

public class VisibleTagsDto extends BaseDto {

    private static final long serialVersionUID = 3121957734237252026L;

    /**
     * 媒体用户id
     */
    private Long mediaId;

    /**
     * 媒体用户可见标签code集，用‘，’分割
     */
    private String visibleTags;

    /**
     * 开启标志（0：关闭，1:开启）
     */
    private Integer openStatus;


    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getVisibleTags() {
        return visibleTags;
    }

    public void setVisibleTags(String visibleTags) {
        this.visibleTags = visibleTags;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public Set<String> convertVisibleTags(){
        if(StringUtils.isBlank(visibleTags)){
            return Collections.emptySet();
        }
        String[] tagStrs = StringUtils.split(visibleTags,SlotShieldConstant.SLOT_SHIELD_SPLITTER);
        return Arrays.stream(tagStrs).map(tagStr -> StringUtils.trim(tagStr)).collect(Collectors.toSet());
    }
}
