package cn.com.duiba.tuia.ssp.center.api.remote;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.tuia.ssp.center.api.dto.mediaapp.AppBaseInfo;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMediaAppService {

    DubboResult<List<MediaAppDto>> selectByMediaId(Long mediaId);
    
    /**
     * 查询app
     *
     * @param appIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<MediaAppDto>>selectByAppIds(List<Long> appIds);

    DubboResult<MediaAppDto> getMediaAppByName(String appName);

    DubboResult<Integer> insert(MediaAppDto mediaAppDto);

    DubboResult<Integer> selectAmountByPageQuery(ReqPageQueryMediaApp reqPageQueryMediaApp);

    DubboResult<List<MediaAppDto>> selectMediaAppList(ReqPageQueryMediaApp reqPageQueryMediaApp);

    DubboResult<Integer> update(ReqUpdateMediaApp reqUpdateMediaApp);

    DubboResult<List<IdAndNameDto>> selectAppIdAndNameByMediaId(Long mediaId);

    DubboResult<List<IdAndNameDto>> selectAppIdAndName(List<Long> appIds);

    /**
     * 此接口也被活动调用
     * @param appId
     * @return
     */
    DubboResult<MediaAppDto> getMediaApp(Long appId);
    
    /**
	 * 通过mediaIds 查询MediaAppDto 列表
	 * @param mediaIds
	 * @return
	 */
    DubboResult<List<MediaAppDto>> selectAppByMediaIds(List<Long> mediaIds);

    DubboResult<List<IdAndNameDto>> getAppIdAndName(List<Long> appIds);

    DubboResult<Boolean> updateMediaAppCache(Long appId);

    DubboResult<Boolean> updateAppIdAndName(Long appId, String appName);

    DubboResult<List<MediaAppDto>> selectBySubAccountId(ReqPageQueryMediaApp req);

    DubboResult<Integer> selectCountBySubAccountId(ReqPageQueryMediaApp req);

    DubboResult<List<MediaAppDto>> selectAppListBySubMediaId(Long mediaId);

    DubboResult<List<MediaAppDto>> selectAppListBySubMediaIds(List<Long> mediaIds);

    /**
     * 如果值存在则更新，使用此接口前，确认sql有更新其字段
     * @param mediaAppDto
     * @return
     */
    DubboResult<Integer> updateIfNotNull(MediaAppDto mediaAppDto);


    DubboResult<List<ManagerDto>> selectAdmin(Long mediaId);

    /**
     * 根据mediaId和媒体app名称模糊查询所有的app基础信息
     * @param mediaId
     * @param appName
     * @return
     */
    List<AppBaseInfo> selectAppBaseInfo(Long mediaId, String appName);

    List<AppBaseInfo> selectAppBaseInfoByAppIds(List<Long> appIds);
}
