package cn.com.duiba.tuia.ssp.center.api.remote;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotStableChargeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 长期计费服务接口
 */
@AdvancedFeignClient
public interface RemoteSlotStableChargeBackendService {
    /**
     * 根据appId查询所有广告位的分成比例配置信息
     * @param appId
     * @return
     */
    DubboResult<List<SlotStableChargeDto>> selectByAppId(Long appId);

    /**
     * 根据slotId更新配置信息
     * @param slotStableChargeDto
     * @return
     */
    DubboResult<Boolean> update(SlotStableChargeDto slotStableChargeDto);

    /**
     * 插入一条配置信息
     * @param slotStableChargeDto
     * @return
     */
    DubboResult<Boolean> insert(SlotStableChargeDto slotStableChargeDto);

    /**
     * 批量更新分成浮动值
     * @param slotStableChargeDtos
     * @return
     */
    DubboResult<Boolean> batchUpdate(List<SlotStableChargeDto> slotStableChargeDtos);
}

