package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.bean.enums.TagBusinessEnum;
import cn.com.duiba.tuia.ssp.center.api.constant.mediaapp.MediaAppTagGroup;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Set;

/**
 * ClassName: RemoteAppIdService <br/>
 * Function: <br/>
 * Date: 2021年06月07日 <br/>
 *
 * @author cuiwx
 */
@AdvancedFeignClient
public interface RemoteAppIdService {
    /**
     * 根据管理员 ID 获取对应的 appId ,如果是当前管理员是 Leader ,则返回组下所有组员的 appId
     * @param adminId  管理员ID
     * @return
     */
    DubboResult<List<Long>> selectAppIdByAdmin(Long adminId);

    /**
     * 根据管理员ID直接查询对应的appId（不查询sso组织架构）
     *
     * @param adminId 管理员IDs
     * @return AppIDs
     */
    Set<Long> listAppIdsByManagerIds(List<Long> adminId);

    /**
     * 根据广告位ID查询媒体ID
     * @param slotId 广告位ID
     * @return appId 媒体ID
     */
    Long getAppIdBySlotId(Long slotId);

    /**
     * 根据标签组ID查询关联的媒体ID
     * 当前为查询程序化媒体提供的接口，目前量级为1K+，后面数据量大了需要注意OOM
     *
     * @param tagGroup 标签组ID映射枚举类
     * @param relationType 标签大类ID映射枚举类
     */
    List<Long> listAppIdByTag(MediaAppTagGroup tagGroup, TagBusinessEnum relationType, List<Long> tagIds);

}
