/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import cn.com.duiba.tuia.ssp.center.api.dto.monthreport.GetSetDate;
import java.io.Serializable;
import java.math.BigDecimal;

public class ConsumeVisitData
implements Serializable,
GetSetDate {
    private static final long serialVersionUID = 8202397074327337965L;
    private String date;
    private Long consumeTotal = 0L;
    private Long mediaActUvPrice = 0L;
    private Long slotRequestPv = 0L;
    private Long slotRequestUv = 0L;

    public ConsumeVisitData() {
    }

    public ConsumeVisitData(String date, Long consumeTotal, Long slotRequestPv, Long slotRequestUv) {
        this.date = date;
        this.consumeTotal = consumeTotal;
        this.slotRequestPv = slotRequestPv;
        this.slotRequestUv = slotRequestUv;
        this.mediaActUvPrice = ConsumeVisitData.calculateAveragePrice(consumeTotal, slotRequestUv);
    }

    public ConsumeVisitData merge(ConsumeVisitData other) {
        this.consumeTotal = this.consumeTotal + other.getConsumeTotal();
        this.slotRequestPv = this.slotRequestPv + other.getSlotRequestPv();
        this.slotRequestUv = this.slotRequestUv + other.getSlotRequestUv();
        this.mediaActUvPrice = ConsumeVisitData.calculateAveragePrice(this.consumeTotal, this.slotRequestUv);
        return this;
    }

    public static Long calculateAveragePrice(Long divisor, Long dividend) {
        Long result = null;
        if (dividend != null && divisor != null && divisor != 0L && dividend != 0L) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 4).longValue();
        }
        return result;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public void setDate(String date) {
        this.date = date;
    }

    public Long getConsumeTotal() {
        return this.consumeTotal;
    }

    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public Long getMediaActUvPrice() {
        return this.mediaActUvPrice;
    }

    public void setMediaActUvPrice(Long mediaActUvPrice) {
        this.mediaActUvPrice = mediaActUvPrice;
    }

    public Long getSlotRequestPv() {
        return this.slotRequestPv;
    }

    public void setSlotRequestPv(Long slotRequestPv) {
        this.slotRequestPv = slotRequestPv;
    }

    public Long getSlotRequestUv() {
        return this.slotRequestUv;
    }

    public void setSlotRequestUv(Long slotRequestUv) {
        this.slotRequestUv = slotRequestUv;
    }
}

