/**
 * Project Name:ssp-center-api
 * File Name:DeliveryType.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.constant
 * Date:2017年11月29日下午7:13:49
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * 描述: 域名状态
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/1/25 09:37
 */
public enum DomainStatusType {

    INIT(0, "初始化"),

    NORMAL(1, "正常"),

    UNUSUAL(2, "异常");

    private Integer type;

    private String desc;


    DomainStatusType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static DomainStatusType getByType(Integer type) {
        for (DomainStatusType e : DomainStatusType.values()) {
            if (e.getType().equals(type)) {
                return e;
            }
        }
        return INIT;
    }

}

