package cn.com.duiba.tuia.ssp.center.api.dto;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class MaterialDto implements Serializable {
    private static final long serialVersionUID = 8180020066933617725L;

    /**
     * 素材图片 类型 0-静态素材.
     */
    public static final int PICTURE_TYPE_STATIC = 0;
    /**
     * 素材图片 类型 1-动态素材
     */
    public static final int PICTURE_TYPE_DYNAMIC = 1;
    /**
     * 素材图片 类型 3-视频素材
     */
    public static final int PICTURE_TYPE_VIDEO = 3;

    private Long id;

    private Date gmtCreate;

    private Date gmtModified;

    private String title;

    private String content;

    private String pictureType;

    private String pictureGroup;

    private Long msId;

    private String msName;

    private String remark;

    private String md5;

    private String designer;

    /**
     * 审核状态
     */
    private Integer auditState;

    /**
     * 审核消息
     */
    private String auditMsg;

    /**
     * 审核图片
     */
    private String auditUrl;

    /**
     * 最后审核提交人
     */
    private Long lastManagerId;

    /**
     * 最后审核提交时间
     */
    private Date submitAuditTime;
    /**
     * 图片属性检索字段
     */
    private String pictureVal;

    /**
     * 图片指纹
     **/
    private String fingerPrint;

    /**
     * 是否为父标识 0-不为父 1-为父
     **/
    private Integer isFather;

    /**
     * 父ID
     **/
    private Long pid;

    /**
     * 子素材数量
     **/
    private Integer sonCount;

    /**
     * 下载次数
     **/
    private Integer downloadNum;

    /**
     * 是否属于adx素材
     */
    private Integer isAdx;

    /**
     * adx素材类别，1:adx人工素材、2:adx算法素材
     */
    private Integer adxMaterialType;

    /**
     *  adx素材尺寸比例区间类别
     */
    private Integer adxRatioType;

    /**
     * 广告主消耗（含增值）
     */
    private Long adCost;

    /**
     * 分成比例,计算公式：adx_cost/（ad_cost/1.15）
     */
    private Double shareProportion;

    /**
     * pv收益
     */
    private Double pvGain;


    /**
     * adx素材来源， 1：adx-人工素材 2：adx-算法素材 3：大盘素材
     */
    private Integer materialSource;

    /**
     * 素材描述
     */
    private String materialDesc;

    /**
     * adx素材类型
     */
    private Integer adxPictureType;

    /**
     * 比例区间描述
     */
    private String ratioTypeDesc;

    /**
     * 尺寸标题
     */
    private String sizeTitle;

    /**
     * 子对象list
     **/
    private List<MaterialDto> children;

    public String getPictureVal() {
        if (StringUtils.isNotBlank(this.content)) {
            List<MCDto> mcDtoList = JSONObject.parseArray(this.content, MCDto.class);
            for (MCDto mdl : mcDtoList) {
                this.pictureVal = mdl.getHeight() + "*" + mdl.getWidth();
            }
        }
        return pictureVal;
    }


    public void setPictureVal(String pictureVal) {
        this.pictureVal = pictureVal;
    }

    /**
     * 素材开启状态，0：关闭，1：开启，不传：全部
     */
    private Integer enableStatus;
    /**
     * 素材定时开关，1：开启，0：关闭
     */
    private Integer regularTimeStatus;
    /**
     * 素材定时生效时间
     */
    private Long regularTimeStart;
    /**
     * 素材定时失效时间
     */
    private Long regularTimeEnd;
    /**
     * 素材媒体定向开关，1：开启，0：关闭
     */
    private Integer mediaLimitStatus;
    /**
     * 素材定向的媒体ID列表
     */
    private List<Long> mediaAppIdList;
    /**
     * 素材标签集合
     */
    private List<String> tagIdList;
    /**
     * 素材定向的媒体列表
     */
    private List<MediaAppDto> mediaAppList;

    /**
     * 素材大小
     */
    private Long pictureSize;

    /**
     * 素材文案-标题
     */
    private String extTitle;
    /**
     * 素材文案-描述
     */
    private String extDesc;
    /**
     * 裁切状态 0：非裁切素材 1：裁切素材
     **/
    private Integer cutState;

    /**
     * 曝光PV
     **/
    private Long exposeCount;
    /**
     * CTR(点击量/曝光量)
     **/
    private Double ctr;

    /**
     * 排序第一的曝光PV (包括子集)
     **/
    private Long firstExposeCount;
    /**
     * 排序第一的CTR(点击量/曝光量) (包括子集)
     **/
    private Double firstCtr;
    /**
     * 排序第一的上传时间
     **/
    private Date firstGmtCreate;


    /**
     * 是否添加至优选库(-1:全部素材 1:已添加 0:未添加)
     **/
    private Integer preferredStatus;

    /**
     * 是否收藏(1:已收藏 0:未收藏)
     */
    private Integer favoriteStatus;

    /**
     * 素材类型（1:单图 2:组图）
     */
    private Integer materialType;

    private Integer formatType;

    private Long dynamicEffectId;

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    public String getPictureType() {
        return pictureType;
    }

    public void setPictureType(String pictureType) {
        this.pictureType = pictureType == null ? null : pictureType.trim();
    }

    public String getPictureGroup() {
        return pictureGroup;
    }

    public void setPictureGroup(String pictureGroup) {
        this.pictureGroup = pictureGroup == null ? null : pictureGroup.trim();
    }

    public Long getMsId() {
        return msId;
    }

    public void setMsId(Long msId) {
        this.msId = msId;
    }

    public String getMsName() {
        return msName;
    }

    public void setMsName(String msName) {
        this.msName = msName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Integer getAuditState() {
        return auditState;
    }

    public void setAuditState(Integer auditState) {
        this.auditState = auditState;
    }

    public String getAuditMsg() {
        return auditMsg;
    }

    public void setAuditMsg(String auditMsg) {
        this.auditMsg = auditMsg;
    }

    public Long getLastManagerId() {
        return lastManagerId;
    }

    public void setLastManagerId(Long lastManagerId) {
        this.lastManagerId = lastManagerId;
    }

    public Date getSubmitAuditTime() {
        return submitAuditTime;
    }

    public void setSubmitAuditTime(Date submitAuditTime) {
        this.submitAuditTime = submitAuditTime;
    }

    public String getAuditUrl() {
        return auditUrl;
    }

    public void setAuditUrl(String auditUrl) {
        this.auditUrl = auditUrl;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getRegularTimeStatus() {
        return regularTimeStatus;
    }

    public void setRegularTimeStatus(Integer regularTimeStatus) {
        this.regularTimeStatus = regularTimeStatus;
    }

    public Long getRegularTimeStart() {
        return regularTimeStart;
    }

    public void setRegularTimeStart(Long regularTimeStart) {
        this.regularTimeStart = regularTimeStart;
    }

    public Long getRegularTimeEnd() {
        return regularTimeEnd;
    }

    public void setRegularTimeEnd(Long regularTimeEnd) {
        this.regularTimeEnd = regularTimeEnd;
    }

    public Integer getMediaLimitStatus() {
        return mediaLimitStatus;
    }

    public void setMediaLimitStatus(Integer mediaLimitStatus) {
        this.mediaLimitStatus = mediaLimitStatus;
    }

    public List<Long> getMediaAppIdList() {
        return mediaAppIdList;
    }

    public void setMediaAppIdList(List<Long> mediaAppIdList) {
        this.mediaAppIdList = mediaAppIdList;
    }

    public List<String> getTagIdList() {
        return tagIdList;
    }

    public void setTagIdList(List<String> tagIdList) {
        this.tagIdList = tagIdList;
    }

    public List<MediaAppDto> getMediaAppList() {
        return mediaAppList;
    }

    public void setMediaAppList(List<MediaAppDto> mediaAppList) {
        this.mediaAppList = mediaAppList;
    }

    public Long getPictureSize() {
        return pictureSize;
    }

    public void setPictureSize(Long pictureSize) {
        this.pictureSize = pictureSize;
    }

    public String getExtTitle() {
        return extTitle;
    }

    public void setExtTitle(String extTitle) {
        this.extTitle = extTitle;
    }

    public String getExtDesc() {
        return extDesc;
    }

    public void setExtDesc(String extDesc) {
        this.extDesc = extDesc;
    }

    public Integer getCutState() {
        return cutState;
    }

    public void setCutState(Integer cutState) {
        this.cutState = cutState;
    }

    public Long getExposeCount() {
        return exposeCount;
    }

    public void setExposeCount(Long exposeCount) {
        this.exposeCount = exposeCount;
    }

    public Double getCtr() {
        return ctr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Integer getPreferredStatus() {
        return preferredStatus;
    }

    public void setPreferredStatus(Integer preferredStatus) {
        this.preferredStatus = preferredStatus;
    }

    public String getFingerPrint() {
        return fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public Integer getIsFather() {
        return isFather;
    }

    public void setIsFather(Integer isFather) {
        this.isFather = isFather;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Integer getFavoriteStatus() {
        return favoriteStatus;
    }

    public void setFavoriteStatus(Integer favoriteStatus) {
        this.favoriteStatus = favoriteStatus;
    }

    public List<MaterialDto> getChildren() {
        return children;
    }

    public void setChildren(List<MaterialDto> children) {
        this.children = children;
    }

    public Long getFirstExposeCount() {
        return firstExposeCount;
    }

    public void setFirstExposeCount(Long firstExposeCount) {
        this.firstExposeCount = firstExposeCount;
    }

    public Double getFirstCtr() {
        return firstCtr;
    }

    public void setFirstCtr(Double firstCtr) {
        this.firstCtr = firstCtr;
    }

    public Integer getSonCount() {
        return sonCount;
    }

    public void setSonCount(Integer sonCount) {
        this.sonCount = sonCount;
    }

    public Integer getDownloadNum() {
        return downloadNum;
    }

    public void setDownloadNum(Integer downloadNum) {
        this.downloadNum = downloadNum;
    }

    public Date getFirstGmtCreate() {
        return firstGmtCreate;
    }

    public void setFirstGmtCreate(Date firstGmtCreate) {
        this.firstGmtCreate = firstGmtCreate;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public Integer getFormatType() {
        return formatType;
    }

    public void setFormatType(Integer formatType) {
        this.formatType = formatType;
    }

    public Integer getIsAdx() {
        return isAdx;
    }

    public void setIsAdx(Integer isAdx) {
        this.isAdx = isAdx;
    }

    public Integer getAdxMaterialType() {
        return adxMaterialType;
    }

    public void setAdxMaterialType(Integer adxMaterialType) {
        this.adxMaterialType = adxMaterialType;
    }

    public Integer getAdxRatioType() {
        return adxRatioType;
    }

    public void setAdxRatioType(Integer adxRatioType) {
        this.adxRatioType = adxRatioType;
    }

    public Long getAdCost() {
        return adCost;
    }

    public void setAdCost(Long adCost) {
        this.adCost = adCost;
    }

    public Double getShareProportion() {
        return shareProportion;
    }

    public void setShareProportion(Double shareProportion) {
        this.shareProportion = shareProportion;
    }

    public Double getPvGain() {
        return pvGain;
    }

    public void setPvGain(Double pvGain) {
        this.pvGain = pvGain;
    }

    public Integer getMaterialSource() {
        return materialSource;
    }

    public void setMaterialSource(Integer materialSource) {
        this.materialSource = materialSource;
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc;
    }

    public Integer getAdxPictureType() {
        return adxPictureType;
    }

    public void setAdxPictureType(Integer adxPictureType) {
        this.adxPictureType = adxPictureType;
    }

    public String getRatioTypeDesc() {
        return ratioTypeDesc;
    }

    public void setRatioTypeDesc(String ratioTypeDesc) {
        this.ratioTypeDesc = ratioTypeDesc;
    }

    public Long getDynamicEffectId() {
        return dynamicEffectId;
    }

    public void setDynamicEffectId(Long dynamicEffectId) {
        this.dynamicEffectId = dynamicEffectId;
    }

    public String getSizeTitle() {
        return sizeTitle;
    }

    public void setSizeTitle(String sizeTitle) {
        this.sizeTitle = sizeTitle;
    }
}