package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;

/**
 * @author fangzhipeng
 * @date 2018/8/3
 *
 * 根据时间段来请求tagCodes内用户对应新增的广告数
 *
 */
public class ReqNewAdvCount implements Serializable {

    private static final long serialVersionUID = -1683237160418728936L;
    /**
     * 媒体Id
     */
    private List<String> tagCodes;

    /**
     * 开始时间 格式 yyyy-MM-dd hh:mm:ss
     */
    private Date startDate;

    /**
     * 结束时间 格式 yyyy-MM-dd hh:mm:ss
     */
    private Date endDate;

    public ReqNewAdvCount() {}

    public ReqNewAdvCount(List<String> tagCodes, String startDate, String endDate) {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
        this.tagCodes = tagCodes;
        this.startDate = Date.from(LocalDateTime.parse(startDate, pattern).atZone(ZoneId.systemDefault()).toInstant());
        this.endDate = Date.from(LocalDateTime.parse(endDate, pattern).atZone(ZoneId.systemDefault()).toInstant());
    }

    public List<String> getTagCodes() {
        return tagCodes;
    }

    public void setTagCodes(List<String> tagCodes) {
        this.tagCodes = tagCodes;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}
