/**
 * Copyright (c) 2019, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.CommonConfigDetailDto;
import cn.com.duiba.tuia.ssp.center.api.dto.CommonConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ConfigHistoryVersionDto;

import java.util.List;

/**
 * 描述:公共配置
 *
 * @auther tangzhen@duiba.com.cn
 * @date 2019/7/04 13:58
 */
@AdvancedFeignClient
public interface RemoteCommonConfigService {

    /**
     * 根据环境查询
     *
     * @param
     * @return
     */
    List<CommonConfigDto> selectByEnv();

    CommonConfigDto selectByParamKey(String key);

    Integer addConfig(CommonConfigDto dto);

    Integer deleteConfigById(Long id);

    Integer updateConfigById(CommonConfigDto dto,String optionUser);

    /**
     * @Author zhangliwei
     * @Description  获取历史版本公共配置list
     * @Date 15:47 2019-08-16
     * @Param [param]
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.HistoryVersionDto>
     **/
    List<CommonConfigDetailDto> getConfigHistoryList();


    /**
     * @Author zhangliwei
     * @Description  公共模块配置回滚到指定版本
     * @Date 16:13 2019-08-16
     * @Param [param, version]
     * @return java.lang.Boolean
     **/
    Boolean rollBackConfig(String param, Integer version,String optionUser);

    /**
     * @Author zhangliwei
     * @Description  根据key值来删除配置以及所有历史记录
     * @Date 14:49 2019-08-21
     * @Param [param]
     * @return java.lang.Integer
     **/
    Integer deleteConfigByParam(String param);

    /**
     * 新增活动公共模块配置
     * @param dto
     * @param optionUser 操作人
     * @return
     */
    Integer addConfigAndRecord(CommonConfigDto dto, String optionUser);
}
