package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.FileCollectShieldConfigDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;
import cn.com.duiba.tuia.ssp.center.api.params.FileCollectShieldParam;
import cn.com.duiba.tuia.ssp.center.api.query.FileCollectShieldConfigQuery;

/**
 * @author K. L. Mao
 * @create 2019-12-10
 */
@AdvancedFeignClient
public interface RemoteFileCollectShieldConfigService {

    /**
     * 查询文件采集屏蔽信息
     * @param shieldParam
     * @return
     */
    Result<FileCollectShieldConfigDTO> queryFileCollectShieldConfig(FileCollectShieldParam shieldParam);

    /**
     * 文件采集屏蔽信息列表
     * @param query
     * @return
     */
    Result<PageResultDto<FileCollectShieldConfigDTO>> queryFileCollectShieldConfigList(FileCollectShieldConfigQuery query);

    /**
     * 创建文件采集屏蔽信息
     * @param shieldAddParam
     * @return
     */
    Result<Void> createFileCollectShield(FileCollectShieldParam shieldAddParam);

    /**
     * 删除文件采集屏蔽信息
     * @param shieldId
     * @return
     */
    Result<Void> deleteFileShield(Long shieldId);

}
