package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.advert;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 〈一句话功能简述〉<br>
 * Description: 广告行业标签变更请求参数
 *
 * @author hillchen
 * @create 2018/11/1 20:28
 */
public class AdvertTagChangeReq extends AdvertBaseReq{

    private String oldTagCode;
    /**
     * 新广告二级属性标签（新增）
     */
    private Set<String> oldAttrTagCode;

    /**
     * 新广告二级落地页标签(新增)
     */
    private Set<String> oldLoadPageCode;

    public String getOldTagCode() {
        return oldTagCode;
    }

    public void setOldTagCode(String oldTagCode) {
        this.oldTagCode = oldTagCode;
    }

    public Set<String> getOldAttrTagCode() {
        return oldAttrTagCode;
    }

    public void setOldAttrTagCode(Set<String> oldAttrTagCode) {
        this.oldAttrTagCode = oldAttrTagCode;
    }

    public Set<String> getOldLoadPageCode() {
        return oldLoadPageCode;
    }

    public void setOldLoadPageCode(Set<String> oldLoadPageCode) {
        this.oldLoadPageCode = oldLoadPageCode;
    }

    public Set<String> computeOldAdvertTagSet() {
        Set<String> advertTags = new HashSet<>();
        advertTags.add(oldTagCode);
        if(CollectionUtils.isNotEmpty(oldAttrTagCode)){
            advertTags.addAll(oldAttrTagCode);
        }
        if(CollectionUtils.isNotEmpty(oldLoadPageCode)){
            advertTags.addAll(oldLoadPageCode);
        }
        return advertTags;
    }

    public boolean buzTagCodeHasChange() {
        return StringUtils.isNotBlank(getTagCode() ) && !getTagCode().equals(oldTagCode);

    }
}