package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Arrays;
import java.util.Objects;

/**
 * Created by ZhangShun at 2020/4/25
 */
public enum SpecificationTemplateTypeEnum {

    CUSTOM(0,  "","自定义"),
    BOTTOM_PIC(1, "700*280",  "上文下图"),
    RIGHT_PIC(2, "225*140", "左文右图"),
    LEFT_PIC(3, "225*140", "左图右文"),
    THREE_PIC(4, "228*150", "三图");

    private Integer type;

    private String spec;

    private String name;

    SpecificationTemplateTypeEnum(Integer type ,String spec, String name) {
        this.type = type;
        this.name = name;
        this.spec = spec;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public String getSpec() {
        return spec;
    }

    public static String getNameByType(Integer type) {
        return Arrays.stream(SpecificationTemplateTypeEnum.values())
                .filter(v -> Objects.equals(v.getType(), type))
                .map(SpecificationTemplateTypeEnum::getName)
                .findFirst().orElse("");
    }

    public static String getTemplateTypeMsName(Integer sckType, String sceneDesc, String spec) {
        return getTemplateTypeMsName(sckType, sceneDesc, spec, null, null, null);
    }

    public static String getTemplateTypeMsName(Integer sckType, String sceneDesc, String spec, Integer templateType, Integer imageWidth, Integer imageHeight) {
        // 不使用素材
        if (Objects.equals(sckType, 6)) {
            return sceneDesc;
        }
        // 兼容老数据
        if (Objects.isNull(sckType) || Objects.isNull(templateType) || Objects.equals(templateType, 0)) {
            if (Objects.equals(imageWidth, 225) && Objects.equals(imageHeight, 140)) {
                return sceneDesc+"(" + SpecificationTemplateTypeEnum.RIGHT_PIC.getName() + ":" + spec + ")";
            } else if (Objects.equals(imageWidth, 700) && Objects.equals(imageHeight, 280)) {
                return sceneDesc+"(" + SpecificationTemplateTypeEnum.BOTTOM_PIC.getName() + ":" + spec + ")";
            }
            return sceneDesc+"(" + SpecificationTemplateTypeEnum.CUSTOM.getName() + ":" + spec + ")";
        }
        String desc = SpecificationTemplateTypeEnum.getNameByType(templateType);
        return sceneDesc+"(" + desc + ":" + spec + ")";
    }

}
