package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * @author duiba
 */

public enum TagLibraryLevelEnum {

    ROOT(0),
    ONE(1),
    TWO(2),
    THREE(3);

    private Integer code;

    public Stream<TagLibraryLevelEnum> flatMap() {
        return Stream.of(this);
    }


    public static Optional<TagLibraryLevelEnum> fromRawValue(Integer code) {
        return Arrays.stream(TagLibraryLevelEnum.values())
                .filter(TagLibraryLevelEnum -> Objects.equals(TagLibraryLevelEnum.code, code))
                .findAny();
    }

    TagLibraryLevelEnum(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
