/**
 * Project Name:media-api File Name:AccountMonthReportDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年11月30日下午3:07:58 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * ClassName:AccountMonthReportDto <br/>
 * Function: 媒体账户月报表. <br/>
 * Date: 2016年11月30日 下午3:07:58 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class AccountMonthReportDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 5406344476349700852L;

    /** id */
    private Long              id;

    /** 媒体用户id */
    private Long              mediaId;

    /** 媒体id */
    private Long              appId;

    /** 广告id */
    private Long              slotId;

    /** 每月曝光数 */
    private Integer           exposureCount;

    /** 每月点击数 */
    private Integer           clickCount;

    /** 每月点击人数 */
    private Integer           clickCountUv;

    /** 每月发券量 */
    private Integer           launchCount;

    /** 广告有效点击量 */
    private Integer           efClickCount;

    /** 实际媒体分成(分) */
    private Long              consumeTotal;

    /** 预计分成(分) */
    private Long              exConsumeTotal;

    /** 每月广告消耗(分) */
    private Long              adConsume;

    /** 日期 */
    private Date              curDate;

    /** 结算状态：0-待结算，1-结算中，2-拒绝结算 3-已结算 */
    private Integer           settlementStatus;
    
    /**提现单号*/
    private Long              cashOrderId;
    
    /**提现状态*/
    private Integer           cashStatus;

    /**结算后媒体分成*/
    private Long              settledMediaDivide;

    /**媒体运营*/
    private String           mediaOperation;
    
    /**风控运营*/
    private String           riskControlOperation;
    
    /**修改时间*/
    private Date             gmtModified;
   
    /**运营结算时间*/
    private Date             cashTime;
    
    /**运营审核时间*/
    private Date             auditTime;

    /**杭州提现单号*/
    private Long             hzCashOrderId;

    /**霍尔果斯提现单号*/
    private Long             hegsCashOrderId;

    /**霍城兑捷提现单号*/
    private Long hcdjCashOrderId;

    /**兑推提现单号*/
    private Long             duituiCashOrderId;
    
    /**杭州提现状态*/
    private Integer         hzCashStatus;
    
    /**霍尔果斯提现状态*/
    private Integer         hegsCashStatus;

    /**霍城兑捷提现状态*/
    private Byte hcdjCashStatus;

    /**兑推提现状态*/
    private Byte duituiCashStatus;

    /** 杭州实际媒体分成(分) */
    private Long              hzConsumeTotal;

    /** 霍尔果斯实际媒体分成(分) */
    private Long              hegsConsumeTotal;

    /** 霍城兑捷实际媒体分成(分) */
    private Long hcdjConsumeTotal;

    /** 兑推实际媒体分成(分) */
    private Long duituiConsumeTotal;

    /** 现金消耗 */
    private Long  cashConsume;
    /** 杭州现金消耗*/
    private Long   hzCashConsume;
    /** 霍尔果斯现金消耗*/
    private Long   hegsCashConsume;
    /** 霍城兑捷现金消耗*/
    private Long hcdjCashConsume;

    /** 兑推现金消耗*/
    private Long duituiCashConsume;

    /**
     * 杭州预结算单号
     */
    private Long hzPreSettleOrderId;

    /**
     * 霍尔果斯预结算单号
     */
    private Long hegsPreSettleOrderId;

    /**
     * 霍城兑捷预结算单号
     */
    private Long hcdjPreSettleOrderId;

    /**
     * 兑推预结算单号
     */
    private Long duituiPreSettleOrderId;

    /**
     * 杭州预结算状态
     */
    private Integer hzPreSettleStatus;

    /**
     * 霍尔果斯预结算状态
     */
    private Integer hegsPreSettleStatus;

    /**
     * 霍城兑捷预结算状态
     */
    private Integer hcdjPreSettleStatus;

    /**
     * 兑推预结算状态
     */
    private Integer duituiPreSettleStatus;

    /**
     * 杭州公司主体调整金额
     */
    private Long hzAdjustmentAmount;
    /**
     * 霍尔果斯公司主体调整金额
     */
    private Long hegsAdjustmentAmount;
    /**
     * 霍城兑捷公司主体调整金额
     */
    private Long hcdjAdjustmentAmount;
    /**
     * 兑推公司主体调整金额
     */
    private Long duituiAdjustmentAmount;

    /** 记录创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date gmtCreate;

    /** 入口曝光量 */
    private Long actExposeCount;

    /** 入口点击量 */
    private Long actClickCount;

    /** 广告位访问UV */
    private Long sdkUv;

    /** 活动广告券请求 */
    private Long advertRequestCount;

    /** 结算拒绝原因 */
    private String rejectReason;

    /** 媒体预计分成按分存储 */
    private Long mediaExDivide;

    /** 媒体应得分成按分存储 */
    private Long mediaDueDivide;

    /** 媒体请款清单状态：0:未请款，1:已请款 */
    private Integer cashRequirementStatus;

    /** 杭州每日广告消耗(分) */
    private Long hzAdConsume;

    /** 霍尔果斯每日广告消耗(分) */
    private Long hegsAdConsume;

    /** 杭州每日媒体预计分成(分） */
    private Long hzExConsumeTotal;

    /** 霍尔果斯每日媒体预计分成(分） */
    private Long hegsExConsumeTotal;

    /** 杭州媒体预计分成按分存储 */
    private Long hzMediaExDivide;

    /** 霍尔果斯媒体预计分成按分存储 */
    private Long hegsMediaExDivide;

    /** 杭州媒体应得分成按分存储 */
    private Long hzMediaDueDivide;

    /** 霍尔果斯媒体应得分成按分存储 */
    private Long hegsMediaDueDivide;

    /** 霍城兑捷每日广告消耗(分) */
    private Long hcdjAdConsume;

    /** 霍城兑捷每日媒体预计分成(分） */
    private Long hcdjExConsumeTotal;

    /** 霍城兑捷媒体预计分成按分存储 */
    private Long hcdjMediaExDivide;

    /** 霍城兑捷媒体应得分成按分存储 */
    private Long hcdjMediaDueDivide;

    /** 兑推每日广告消耗(分) */
    private Long duituiAdConsume;

    /** 兑推每日媒体预计分成(分） */
    private Long duituiExConsumeTotal;

    /** 兑推媒体预计分成按分存储 */
    private Long duituiMediaExDivide;

    /** 兑推媒体应得分成按分存储 */
    private Long duituiMediaDueDivide;

    private Integer prePayApp;

    public Integer getPrePayApp() {
        return prePayApp;
    }

    public void setPrePayApp(Integer prePayApp) {
        this.prePayApp = prePayApp;
    }

    public Long getHzAdjustmentAmount() {
        return hzAdjustmentAmount;
    }

    public void setHzAdjustmentAmount(Long hzAdjustmentAmount) {
        this.hzAdjustmentAmount = hzAdjustmentAmount;
    }

    public Long getHegsAdjustmentAmount() {
        return hegsAdjustmentAmount;
    }

    public void setHegsAdjustmentAmount(Long hegsAdjustmentAmount) {
        this.hegsAdjustmentAmount = hegsAdjustmentAmount;
    }

    public Long getHcdjAdjustmentAmount() {
        return hcdjAdjustmentAmount;
    }

    public void setHcdjAdjustmentAmount(Long hcdjAdjustmentAmount) {
        this.hcdjAdjustmentAmount = hcdjAdjustmentAmount;
    }

    /**
     * settlementStatus.
     *
     * @return the settlementStatus
     * @since JDK 1.6
     */
    public Integer getSettlementStatus() {
        return settlementStatus;
    }

    /**
     * settlementStatus.
     *
     * @param settlementStatus the settlementStatus to set
     * @since JDK 1.6
     */
    public void setSettlementStatus(Integer settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    /**
     * id.
     *
     * @return the id
     * @since JDK 1.6
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     * @since JDK 1.6
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Integer getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Integer exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Integer getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Integer clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * launchCount.
     *
     * @return the launchCount
     * @since JDK 1.6
     */
    public Integer getLaunchCount() {
        return launchCount;
    }

    /**
     * launchCount.
     *
     * @param launchCount the launchCount to set
     * @since JDK 1.6
     */
    public void setLaunchCount(Integer launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * efClickCount.
     *
     * @return the efClickCount
     * @since JDK 1.6
     */
    public Integer getEfClickCount() {
        return efClickCount;
    }

    /**
     * efClickCount.
     *
     * @param efClickCount the efClickCount to set
     * @since JDK 1.6
     */
    public void setEfClickCount(Integer efClickCount) {
        this.efClickCount = efClickCount;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * clickCountUv.
     *
     * @return the clickCountUv
     * @since JDK 1.6
     */
    public Integer getClickCountUv() {
        return clickCountUv;
    }

    /**
     * clickCountUv.
     *
     * @param clickCountUv the clickCountUv to set
     * @since JDK 1.6
     */
    public void setClickCountUv(Integer clickCountUv) {
        this.clickCountUv = clickCountUv;
    }

    /**
     * exConsumeTotal.
     *
     * @return the exConsumeTotal
     * @since JDK 1.6
     */
    public Long getExConsumeTotal() {
        return exConsumeTotal;
    }

    /**
     * exConsumeTotal.
     *
     * @param exConsumeTotal the exConsumeTotal to set
     * @since JDK 1.6
     */
    public void setExConsumeTotal(Long exConsumeTotal) {
        this.exConsumeTotal = exConsumeTotal;
    }

    /**
     * adConsume.
     *
     * @return the adConsume
     * @since JDK 1.6
     */
    public Long getAdConsume() {
        return adConsume;
    }

    /**
     * adConsume.
     *
     * @param adConsume the adConsume to set
     * @since JDK 1.6
     */
    public void setAdConsume(Long adConsume) {
        this.adConsume = adConsume;
    }
    
    /**
     * cashOrderId.
     *
     * @return the cashOrderId
     * @since JDK 1.6
     */
    public Long getCashOrderId() {
        return cashOrderId;
    }

    /**
     * cashOrderId.
     *
     * @param cashOrderId the cashOrderId to set
     * @since JDK 1.6
     */
    public void setCashOrderId(Long cashOrderId) {
        this.cashOrderId = cashOrderId;
    }
    
    
    /**
     * cashStatus.
     *
     * @return the cashStatus
     * @since JDK 1.6
     */
    public Integer getCashStatus() {
        return cashStatus;
    }
    
    /**
     * cashStatus.
     *
     * @param cashStatus the cashStatus to set
     * @since JDK 1.6
     */
    public void setCashStatus(Integer cashStatus) {
        this.cashStatus = cashStatus;
    }

    public Long getSettledMediaDivide() {
        return settledMediaDivide;
    }

    public void setSettledMediaDivide(Long settledMediaDivide) {
        this.settledMediaDivide = settledMediaDivide;
    }
    
    public String getMediaOperation() {
        return mediaOperation;
    }

    
    public void setMediaOperation(String mediaOperation) {
        this.mediaOperation = mediaOperation;
    }

    
    public String getRiskControlOperation() {
        return riskControlOperation;
    }

    
    public void setRiskControlOperation(String riskControlOperation) {
        this.riskControlOperation = riskControlOperation;
    }

    
    public Date getGmtModified() {
        return gmtModified;
    }

    
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
    
    
    public Date getCashTime() {
        return cashTime;
    }

    
    public void setCashTime(Date cashTime) {
        this.cashTime = cashTime;
    }

    
    public Date getAuditTime() {
        return auditTime;
    }
    
    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }
    
    public Integer getHzCashStatus() {
        return hzCashStatus;
    }

    
    public void setHzCashStatus(Integer hzCashStatus) {
        this.hzCashStatus = hzCashStatus;
    }

    public Integer getHegsCashStatus() {
        return hegsCashStatus;
    }

    public void setHegsCashStatus(Integer hegsCashStatus) {
        this.hegsCashStatus = hegsCashStatus;
    }

    public Long getHzConsumeTotal() {
        return hzConsumeTotal;
    }

    public void setHzConsumeTotal(Long hzConsumeTotal) {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    public Long getHegsConsumeTotal() {
        return hegsConsumeTotal;
    }

    public void setHegsConsumeTotal(Long hegsConsumeTotal) {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getHzCashOrderId() {
        return hzCashOrderId;
    }

    public void setHzCashOrderId(Long hzCashOrderId) {
        this.hzCashOrderId = hzCashOrderId;
    }

    public Long getHegsCashOrderId() {
        return hegsCashOrderId;
    }

    public void setHegsCashOrderId(Long hegsCashOrderId) {
        this.hegsCashOrderId = hegsCashOrderId;
    }

    public Long getCashConsume() {
        return cashConsume;
    }

    public void setCashConsume(Long cashConsume) {
        this.cashConsume = cashConsume;
    }

    public Long getHzCashConsume() {
        return hzCashConsume;
    }

    public void setHzCashConsume(Long hzCashConsume) {
        this.hzCashConsume = hzCashConsume;
    }

    public Long getHegsCashConsume() {
        return hegsCashConsume;
    }

    public void setHegsCashConsume(Long hegsCashConsume) {
        this.hegsCashConsume = hegsCashConsume;
    }

    public Long getHcdjCashOrderId() {
        return hcdjCashOrderId;
    }

    public void setHcdjCashOrderId(final Long hcdjCashOrderId) {
        this.hcdjCashOrderId = hcdjCashOrderId;
    }

    public Byte getHcdjCashStatus() {
        return hcdjCashStatus;
    }

    public void setHcdjCashStatus(final Byte hcdjCashStatus) {
        this.hcdjCashStatus = hcdjCashStatus;
    }

    public Long getHcdjCashConsume() {
        return hcdjCashConsume;
    }

    public void setHcdjCashConsume(final Long hcdjCashConsume) {
        this.hcdjCashConsume = hcdjCashConsume;
    }

    public Long getHcdjConsumeTotal() {
        return hcdjConsumeTotal;
    }

    public void setHcdjConsumeTotal(final Long hcdjConsumeTotal) {
        this.hcdjConsumeTotal = hcdjConsumeTotal;
    }

    public Long getHzPreSettleOrderId() {
        return hzPreSettleOrderId;
    }

    public void setHzPreSettleOrderId(Long hzPreSettleOrderId) {
        this.hzPreSettleOrderId = hzPreSettleOrderId;
    }

    public Long getHegsPreSettleOrderId() {
        return hegsPreSettleOrderId;
    }

    public void setHegsPreSettleOrderId(Long hegsPreSettleOrderId) {
        this.hegsPreSettleOrderId = hegsPreSettleOrderId;
    }

    public Long getHcdjPreSettleOrderId() {
        return hcdjPreSettleOrderId;
    }

    public void setHcdjPreSettleOrderId(Long hcdjPreSettleOrderId) {
        this.hcdjPreSettleOrderId = hcdjPreSettleOrderId;
    }

    public Integer getHzPreSettleStatus() {
        return hzPreSettleStatus;
    }

    public void setHzPreSettleStatus(Integer hzPreSettleStatus) {
        this.hzPreSettleStatus = hzPreSettleStatus;
    }

    public Integer getHegsPreSettleStatus() {
        return hegsPreSettleStatus;
    }

    public void setHegsPreSettleStatus(Integer hegsPreSettleStatus) {
        this.hegsPreSettleStatus = hegsPreSettleStatus;
    }

    public Integer getHcdjPreSettleStatus() {
        return hcdjPreSettleStatus;
    }

    public void setHcdjPreSettleStatus(Integer hcdjPreSettleStatus) {
        this.hcdjPreSettleStatus = hcdjPreSettleStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Long getActExposeCount() {
        return actExposeCount;
    }

    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }

    public Long getActClickCount() {
        return actClickCount;
    }

    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getAdvertRequestCount() {
        return advertRequestCount;
    }

    public void setAdvertRequestCount(Long advertRequestCount) {
        this.advertRequestCount = advertRequestCount;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public Long getMediaExDivide() {
        return mediaExDivide;
    }

    public void setMediaExDivide(Long mediaExDivide) {
        this.mediaExDivide = mediaExDivide;
    }

    public Long getMediaDueDivide() {
        return mediaDueDivide;
    }

    public void setMediaDueDivide(Long mediaDueDivide) {
        this.mediaDueDivide = mediaDueDivide;
    }

    public Integer getCashRequirementStatus() {
        return cashRequirementStatus;
    }

    public void setCashRequirementStatus(Integer cashRequirementStatus) {
        this.cashRequirementStatus = cashRequirementStatus;
    }

    public Long getHzAdConsume() {
        return hzAdConsume;
    }

    public void setHzAdConsume(Long hzAdConsume) {
        this.hzAdConsume = hzAdConsume;
    }

    public Long getHegsAdConsume() {
        return hegsAdConsume;
    }

    public void setHegsAdConsume(Long hegsAdConsume) {
        this.hegsAdConsume = hegsAdConsume;
    }

    public Long getHzExConsumeTotal() {
        return hzExConsumeTotal;
    }

    public void setHzExConsumeTotal(Long hzExConsumeTotal) {
        this.hzExConsumeTotal = hzExConsumeTotal;
    }

    public Long getHegsExConsumeTotal() {
        return hegsExConsumeTotal;
    }

    public void setHegsExConsumeTotal(Long hegsExConsumeTotal) {
        this.hegsExConsumeTotal = hegsExConsumeTotal;
    }

    public Long getHzMediaExDivide() {
        return hzMediaExDivide;
    }

    public void setHzMediaExDivide(Long hzMediaExDivide) {
        this.hzMediaExDivide = hzMediaExDivide;
    }

    public Long getHegsMediaExDivide() {
        return hegsMediaExDivide;
    }

    public void setHegsMediaExDivide(Long hegsMediaExDivide) {
        this.hegsMediaExDivide = hegsMediaExDivide;
    }

    public Long getHzMediaDueDivide() {
        return hzMediaDueDivide;
    }

    public void setHzMediaDueDivide(Long hzMediaDueDivide) {
        this.hzMediaDueDivide = hzMediaDueDivide;
    }

    public Long getHegsMediaDueDivide() {
        return hegsMediaDueDivide;
    }

    public void setHegsMediaDueDivide(Long hegsMediaDueDivide) {
        this.hegsMediaDueDivide = hegsMediaDueDivide;
    }

    public Long getHcdjAdConsume() {
        return hcdjAdConsume;
    }

    public void setHcdjAdConsume(Long hcdjAdConsume) {
        this.hcdjAdConsume = hcdjAdConsume;
    }

    public Long getHcdjExConsumeTotal() {
        return hcdjExConsumeTotal;
    }

    public void setHcdjExConsumeTotal(Long hcdjExConsumeTotal) {
        this.hcdjExConsumeTotal = hcdjExConsumeTotal;
    }

    public Long getHcdjMediaExDivide() {
        return hcdjMediaExDivide;
    }

    public void setHcdjMediaExDivide(Long hcdjMediaExDivide) {
        this.hcdjMediaExDivide = hcdjMediaExDivide;
    }

    public Long getHcdjMediaDueDivide() {
        return hcdjMediaDueDivide;
    }

    public void setHcdjMediaDueDivide(Long hcdjMediaDueDivide) {
        this.hcdjMediaDueDivide = hcdjMediaDueDivide;
    }

    public Long getDuituiCashOrderId() {
        return duituiCashOrderId;
    }

    public void setDuituiCashOrderId(Long duituiCashOrderId) {
        this.duituiCashOrderId = duituiCashOrderId;
    }

    public Byte getDuituiCashStatus() {
        return duituiCashStatus;
    }

    public void setDuituiCashStatus(Byte duituiCashStatus) {
        this.duituiCashStatus = duituiCashStatus;
    }

    public Long getDuituiConsumeTotal() {
        return duituiConsumeTotal;
    }

    public void setDuituiConsumeTotal(Long duituiConsumeTotal) {
        this.duituiConsumeTotal = duituiConsumeTotal;
    }

    public Long getDuituiCashConsume() {
        return duituiCashConsume;
    }

    public void setDuituiCashConsume(Long duituiCashConsume) {
        this.duituiCashConsume = duituiCashConsume;
    }

    public Long getDuituiPreSettleOrderId() {
        return duituiPreSettleOrderId;
    }

    public void setDuituiPreSettleOrderId(Long duituiPreSettleOrderId) {
        this.duituiPreSettleOrderId = duituiPreSettleOrderId;
    }

    public Integer getDuituiPreSettleStatus() {
        return duituiPreSettleStatus;
    }

    public void setDuituiPreSettleStatus(Integer duituiPreSettleStatus) {
        this.duituiPreSettleStatus = duituiPreSettleStatus;
    }

    public Long getDuituiAdjustmentAmount() {
        return duituiAdjustmentAmount;
    }

    public void setDuituiAdjustmentAmount(Long duituiAdjustmentAmount) {
        this.duituiAdjustmentAmount = duituiAdjustmentAmount;
    }

    public Long getDuituiAdConsume() {
        return duituiAdConsume;
    }

    public void setDuituiAdConsume(Long duituiAdConsume) {
        this.duituiAdConsume = duituiAdConsume;
    }

    public Long getDuituiExConsumeTotal() {
        return duituiExConsumeTotal;
    }

    public void setDuituiExConsumeTotal(Long duituiExConsumeTotal) {
        this.duituiExConsumeTotal = duituiExConsumeTotal;
    }

    public Long getDuituiMediaExDivide() {
        return duituiMediaExDivide;
    }

    public void setDuituiMediaExDivide(Long duituiMediaExDivide) {
        this.duituiMediaExDivide = duituiMediaExDivide;
    }

    public Long getDuituiMediaDueDivide() {
        return duituiMediaDueDivide;
    }

    public void setDuituiMediaDueDivide(Long duituiMediaDueDivide) {
        this.duituiMediaDueDivide = duituiMediaDueDivide;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
