package cn.com.duiba.tuia.ssp.center.api.dto;


import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 媒体账户金额调整表
 */
@Data
public class MediaCostDTO implements Serializable {

    private static final long serialVersionUID = 4695028869381280866L;

    private Long id;
    /**
     * 媒体类型 1-快手 2-百度
     */
    private Integer mediaType;
    /**
     * 当前时间
     */
    private Date curDate;
    /**
     * 当前小时
     */
    private Integer hour;
    /**
     * 时间范围
     */
    private String timeRange;
    /**
     * 原媒体消耗
     */
    private BigDecimal originalMediaCost;
    /**
     * 原广告主消耗
     */
    private BigDecimal originalAdvertCost;
    /**
     * 媒体消耗
     */
    private BigDecimal mediaCost;
    /**
     * 广告主消耗
     */
    private BigDecimal advertCost;

    private BigDecimal profit;

}
