package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel
public class MediaRewardStrategyDto implements Serializable {

    private static final long serialVersionUID = -8049651102863741428L;

    private Long id;

    @ApiModelProperty(value = "媒体帐号ID")
    private Long mediaId;

    /**
     * 策略类型 0月度|1季度
     */
    @ApiModelProperty(value = "策略类型 0月度|1季度")
    private Integer type;

    @ApiModelProperty(value = "周期2018-01/2018-Q1")
    private String curCycle;

    /**
     * 奖励规则
     */
    @ApiModelProperty(value = "奖励规则")
    private List<RewardRule> rewardRule;

    /**
     * 季度/月度任务
     */
    @ApiModelProperty(value = "季度/月度任务")
    private Long targetAmount;
    /**
     * 完成率下限
     */
    @ApiModelProperty(value = "完成率下限")
    private Double lowerLimitRate;
    /**
     * 完成率上限
     */
    @ApiModelProperty(value = "完成率上限")
    private Double upperLimitRate;
    /**
     * 奖励类型 0返点|1固定奖励
     */
    @ApiModelProperty(value = "奖励类型 0返点|1固定奖励")
    private Integer rewardType;
    /**
     * 奖励状态 0待生成|1已生成
     */
    @ApiModelProperty(value = "奖励状态 0待生成|1已生成")
    private Integer rewardStatus;

    private Date gmtCreate;

    private Date gmtModified;

    /**
     * 奖励规则
     */
    @ApiModel
    public static class RewardRule implements Serializable {

        private static final long serialVersionUID = -8401738397671927130L;

        //分数（两位小数）
        @ApiModelProperty(value = "分数（两位小数）", required = true)
        private Double score;

        //奖励比例/固定金额（分）
        @ApiModelProperty(value = "奖励比例/固定金额（分）", required = true)
        private Double rewardRatio;

        public Double getScore() {
            return score;
        }

        public void setScore(Double score) {
            this.score = score;
        }

        public Double getRewardRatio() {
            return rewardRatio;
        }

        public void setRewardRatio(Double rewardRatio) {
            this.rewardRatio = rewardRatio;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCurCycle() {
        return curCycle;
    }

    public void setCurCycle(String curCycle) {
        this.curCycle = curCycle;
    }

    public List<RewardRule> getRewardRule() {
        return rewardRule;
    }

    public void setRewardRule(List<RewardRule> rewardRule) {
        this.rewardRule = rewardRule;
    }

    public Long getTargetAmount() {
        return targetAmount;
    }

    public void setTargetAmount(Long targetAmount) {
        this.targetAmount = targetAmount;
    }

    public Double getLowerLimitRate() {
        return lowerLimitRate;
    }

    public void setLowerLimitRate(Double lowerLimitRate) {
        this.lowerLimitRate = lowerLimitRate;
    }

    public Double getUpperLimitRate() {
        return upperLimitRate;
    }

    public void setUpperLimitRate(Double upperLimitRate) {
        this.upperLimitRate = upperLimitRate;
    }

    public Integer getRewardType() {
        return rewardType;
    }

    public void setRewardType(Integer rewardType) {
        this.rewardType = rewardType;
    }

    public Integer getRewardStatus() {
        return rewardStatus;
    }

    public void setRewardStatus(Integer rewardStatus) {
        this.rewardStatus = rewardStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
