package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * ClassName:ReqApiVersionDto <br/>
 * Function: 常见问题菜单查询类 <br/>
 * Date: 2018年6月20日 下午4:00:37 <br/>
 *
 * @author lijian
 * @see
 * @since JDK 1.8
 */
@ApiModel
public class ReqProblemMenusDto extends BaseQueryDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "问题类别", required = false)
    private String problemCategory;

    /**
     * 页面类型(1:SDK对接优势 2:我是开发 3:我是运营)'
     */
    private Integer pageType;

    /**
     * 对接类型(1:快速对接 2:IOS SDK对接 3:Android SDK对接 4:API对接 5:JS对接)
     */
    private Integer pageSetupType;

    public String getProblemCategory() {
        return problemCategory;
    }

    public void setProblemCategory(String problemCategory) {
        this.problemCategory = problemCategory;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public Integer getPageSetupType() {
        return pageSetupType;
    }

    public void setPageSetupType(Integer pageSetupType) {
        this.pageSetupType = pageSetupType;
    }
}
