/**
 * Project Name:media-api File Name:RspBaseInnerLog.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2017年2月16日下午2:12:30 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * ClassName:RspBaseInnerLog <br/>
 * Function: 基础内部日志 <br/>
 * Date: 2017年2月16日 下午2:12:30 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspBaseInnerLogDto implements Serializable {

    /**序列号*/
    private static final long serialVersionUID = 8463117542794944140L;

    /** 分组日志类型-广告平台业务 */
    public static final Integer GROUP_TYPE_LOG = 1;

    /** 记录日志类型-媒体信息操作记录 */
    public static final Integer MEDIA_TYPE_LOG = 11;

    /** 记录日志类型-广告位信息操作记录 */
    public static final Integer SLOT_TYPE_LOG  = 12;

    /** 大类分组 */
    private Integer             group;
    /** 小类分组 */
    private Integer             type;
    /** 时间 */
    private String              time;
    /** 位置信息 */
    private String              dpm;
    /** 内容信息 */
    private String              dcm;
    /** json数据 */
    private String              json;

    public RspBaseInnerLogDto() {
    }

    /**
     * Creates a new instance of RspBaseInnerLogDto.
     *
     * @param group
     * @param type
     * @param time
     * @param dpm
     * @param dcm
     * @param json
     */
    public RspBaseInnerLogDto(Integer group, Integer type, String time, String dpm, String dcm, String json) {
        super();
        this.group = group;
        this.type = type;
        this.time = time;
        this.dpm = dpm;
        this.dcm = dcm;
        this.json = json;
    }

    /**
     * group.
     *
     * @return the group
     * @since JDK 1.6
     */
    public Integer getGroup() {
        return group;
    }

    /**
     * group.
     *
     * @param group the group to set
     * @since JDK 1.6
     */
    public void setGroup(Integer group) {
        this.group = group;
    }

    /**
     * type.
     *
     * @return the type
     * @since JDK 1.6
     */
    public Integer getType() {
        return type;
    }

    /**
     * type.
     *
     * @param type the type to set
     * @since JDK 1.6
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * time.
     *
     * @return the time
     * @since JDK 1.6
     */
    public String getTime() {
        return time;
    }

    /**
     * time.
     *
     * @param time the time to set
     * @since JDK 1.6
     */
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * dpm.
     *
     * @return the dpm
     * @since JDK 1.6
     */
    public String getDpm() {
        return dpm;
    }

    /**
     * dpm.
     *
     * @param dpm the dpm to set
     * @since JDK 1.6
     */
    public void setDpm(String dpm) {
        this.dpm = dpm;
    }

    /**
     * dcm.
     *
     * @return the dcm
     * @since JDK 1.6
     */
    public String getDcm() {
        return dcm;
    }

    /**
     * dcm.
     *
     * @param dcm the dcm to set
     * @since JDK 1.6
     */
    public void setDcm(String dcm) {
        this.dcm = dcm;
    }

    /**
     * json.
     *
     * @return the json
     * @since JDK 1.6
     */
    public String getJson() {
        return json;
    }

    /**
     * json.
     *
     * @param json the json to set
     * @since JDK 1.6
     */
    public void setJson(String json) {
        this.json = json;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
