package cn.com.duiba.tuia.ssp.center.api.dto.newMedia;

import cn.com.duiba.tuia.ssp.center.api.constant.enums.NewMediaSlotImportEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class NewMediaSaveDTO implements Serializable {

    /**
     * 媒体id列表
     */
    private List<Long> appIds;

    /**
     * 广告位id列表
     */
    private List<Long> slotIds;

    /**
     * 流量突破比例
     */
    private Integer flowBreakoutRatio;

    /**
     * 移除周期
     */
    private Integer removePeriod;

    /**
     * 是否冷启动
     */
    private Integer isColdStart;

    /**
     * 导入方式
     *
     * @see NewMediaSlotImportEnum#name()
     */
    private String importType;
}
