package cn.com.duiba.tuia.ssp.center.api.dto.risk.audit;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * Description: 媒体素材审核查询对象
 *
 * @author hillchen
 * @create 2018/9/14 下午2:02
 */
@ApiModel
public class MaterialAuditReq implements Serializable {
    private static final long serialVersionUID = 424870182870304456L;

    @ApiModelProperty(value = "审核状态")
    private Integer auditState;

    @ApiModelProperty(value = "素材id")
    private Long materialId;

    @ApiModelProperty(value = "素材标题")
    private String materialTitle;

    /** 起始记录数. */
    protected Integer rowStart = 0;

    /** 当前页. */
    protected Integer currentPage = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    protected Integer pageSize;

    public Integer getAuditState() {
        return auditState;
    }

    public void setAuditState(Integer auditState) {
        this.auditState = auditState;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialTitle() {
        return materialTitle;
    }

    public void setMaterialTitle(String materialTitle) {
        this.materialTitle = materialTitle;
    }

    public Integer getRowStart() {
        return rowStart;
    }

    public void setRowStart(Integer rowStart) {
        this.rowStart = rowStart;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}