package cn.com.duiba.tuia.ssp.center.api.dto.sdk;

import lombok.Data;
import org.apache.commons.collections.ListUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author K. L. Mao
 * @create 2020-01-03
 */
@Data
public class SdkCrashOverviewDTO implements Serializable {

    //启动次数
    private Long startNum;
    //启动设备数
    private Long startDeviceNum;
    //崩溃次数
    private Long errorTimes;
    //影响设备数
    private Long errorDevice;
    //pv崩溃率
    private Double pvCollapseRate;
    //uv崩溃率
    private Double uvCollapseRate;


    //pv崩溃率List his历史七日，new 是当前查询条件下的值
    private List<Double> pvCollapseRateNewList;
    //pv崩溃率List历史
    private List<Double> pvCollapseRateHisList;

    //uv崩溃率List
    private List<Double> uvCollapseRateNewList;
    //uv崩溃率List 历史
    private List<Double> uvCollapseRateHisList;

    //崩溃次数List
    private List<Double> errorTimesList;
    //崩溃次数List 历史
    private List<Double> errorTimesHisList;

    //影响设备数List
    private List<Double> errorDeviceList;

    //影响设备数List历史
    private List<Double> errorDeviceHisList;

    public static SdkCrashOverviewDTO defaultNullValue(){
        SdkCrashOverviewDTO overviewDTO = new SdkCrashOverviewDTO();
        overviewDTO.setStartNum(0L);
        overviewDTO.setStartDeviceNum(0L);
        overviewDTO.setErrorTimes(0L);
        overviewDTO.setPvCollapseRate(0D);
        overviewDTO.setUvCollapseRate(0D);
        return overviewDTO;
    }

    public static void fillEmptyListValue(SdkCrashOverviewDTO oldValue) {
        oldValue.setPvCollapseRateNewList(ListUtils.EMPTY_LIST);
        oldValue.setPvCollapseRateHisList(ListUtils.EMPTY_LIST);
        oldValue.setUvCollapseRateNewList(ListUtils.EMPTY_LIST);
        oldValue.setUvCollapseRateHisList(ListUtils.EMPTY_LIST);
        oldValue.setErrorTimesList(ListUtils.EMPTY_LIST);
        oldValue.setErrorTimesHisList(ListUtils.EMPTY_LIST);
        oldValue.setErrorDeviceList(ListUtils.EMPTY_LIST);
        oldValue.setErrorDeviceHisList(ListUtils.EMPTY_LIST);
    }
}
