package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountChangeAdjustAuditDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountChangeDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAccountChangeAdjustAuditService {
    /**
     * 调整账户余额
     * @param accountChangeDto
     * @param accountChangeAdjustAuditDTO
     */
    void adjustAccountAmount(AccountChangeDto accountChangeDto, AccountChangeAdjustAuditDTO accountChangeAdjustAuditDTO);
    /**
     * 插入数据
     * @param accountChangeAdjustAuditDTO
     * @return
     */
    Boolean insert(AccountChangeAdjustAuditDTO accountChangeAdjustAuditDTO);

    /**
     * 复合条件分页查询
     * @param accountChangeAdjustAuditDTO
     * @return
     */
    PageResultDto<AccountChangeAdjustAuditDTO> listByPage(AccountChangeAdjustAuditDTO accountChangeAdjustAuditDTO);

    /**
     * 通过复合条件查询
     * @param accountChangeAdjustAuditDTO
     * @return
     */
    List<AccountChangeAdjustAuditDTO> queryByCondition(AccountChangeAdjustAuditDTO accountChangeAdjustAuditDTO);

}
