package cn.com.duiba.tuia.ssp.center.api.remote;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteAccountReportMonthService {

    DubboResult<Integer> selectAmountByPage(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<List<SettledMonthReportRsp>> selectListByPage(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<SettledMonthReportRsp> selectAdjustedAmountByReportId(Long reportId);

    DubboResult<Integer> selectAgentSettleAmount(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<List<AgentSettledMonthReportRsp>> selectAgentSettleList(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<AccountMonthReportDto> selectMonthReportByReportId(Long reportId);

    DubboResult<List<SettledMonthReportRsp>> selectExportList(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<List<AgentSettledMonthReportRsp>> selectAgentExportList(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    @RequestMapping("/updateMonthReportStatus2")
    DubboResult<Boolean> updateMonthReportStatus(Long appId, Date curDate,Integer settlementStatus);

    @RequestMapping("/updateMonthReportStatus1")
    DubboResult<Boolean> updateMonthReportStatus(UpdateMonthReportDto req);


    /**
     * 查询媒体所有可提现月账单
     * @param mediaId
     * @return
     */
    DubboResult<List<AccountMonthReportDto>> selectByMediaId (Long mediaId);

    /**
     * 通过提现单查询月账单
     * @param cashOrderId
     * @return
     */
    DubboResult<List<AccountMonthReportDto>> selectByCashOrderId ( Long cashOrderId);

    /**
     *
     * 查询用户下所有的月账单数据
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */

    DubboResult<List<AccountMonthReportDto>> selectAllMonthBillList(ReqMonthBillDto param);
    /**
     *
     * 查询用户下所有的月账单总数
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> selectAllMonthBillCount(ReqMonthBillDto param);

    /**
     * 查询媒体下各个应用的每月的预计分成
     *
     * @param cashOrderId
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectBillByCashOrder(Long cashOrderId);

    /**
     * 通过提现单id查询
     * @param cashOrderIds
     * @return
     */
    List<AccountMonthReportDto> selectBillByCashOrderIds(List<Long> cashOrderIds);

    /**
     * @Author zhangliwei
     * @Description  根据结算单号查询
     * @Date 20:17 2020-04-01
     * @Param [cashOrderId]
     * @return cn.com.duiba.wolf.dubbo.DubboResult<java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.AccountMonthReportDto>>
     **/
    DubboResult<List<AccountMonthReportDto>> selectBillByPreSettleOrder(Long cashOrderId);

    List<AccountMonthReportDto> listPreSettleOrderByOrderIds(List<Long> orderIds);

    /**
     * 查询已结算月账单
     *
     * @param monthBillId
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountMonthReportDto> selectSettledMonthBill(Long monthBillId);

    /**
     * 通过体现单查询对应的提现金额
     * 如果传入为null或长度为0的集合，则返回空的集合
     */
    DubboResult<List<SettlementCashOrderDto>> selectSettlementByCashOrderIds(List<Long> cashOrderIds);

    /**
     * 按月份和app id查询月账单信息
     */
    DubboResult<AccountMonthReportDto> selectByAppAndDate(Long appId,Date curDate);

    /**
     *
     * 查询月账单结合通过ids. <br/>
     *
     * @author guyan
     * @param appIds
     * @param curDates
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectMonthBillListByIds(List<Long> appIds,List<String> curDates,Long mediaId);

    /**
     *
     * 查询月账单集合id. <br/>
     *
     * @author guyan
     * @param appId
     * @param curDate
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectMonthBillListById(Long appId,String curDate,Long mediaId);

    /**
     *
     * 查询月账单通过月账单类型. <br/>
     *
     * @author guyan
     * @param billType
     * @param cashOrderId
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> getMonthBillByType(Integer billType, Long cashOrderId,
                                     Long mediaId,List<Long> monthBillIds);

    /**
     *
     * 查询月账单通过月账单类型. <br/>
     *
     * @author guyan
     * @param billType
     * @param cashOrderId
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> getMonthBillByCompanyType(Integer billType, Long cashOrderId,
                                                                Long mediaId,List<Long> monthBillIds, Integer companyType);


    List<AccountMonthReportDto> getAllMonthBillByType(ReqCashParam param);

    /**
     *
     * selectReportMonthSum <br/>
     *
     * @author guyan
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<SettledMonthReportRsp> selectReportMonthSum(ReqAccountMonthReportByPage req);

    /**
     *
     * updateCashRequirement:(更新请款清单). <br/>
     *
     * @author guyan
     * @param cashOrderId
     * @return
     */
    DubboResult<Boolean> updateCashRequirement(Long cashOrderId);

    /**
     * updateMediaOperationName:(更新媒体运营姓名). <br/>
     *
     * @author guyan
     * @param appId
     * @param curDate
     * @param personName
     * @return
     */
    DubboResult<Boolean> updateMediaOperationName(Long appId, Date curDate,String mediaOperationName);

    /**
     *
     * selectBillByCashOrderIds:(通过提现ids查询月账单). <br/>
     *
     * @author guyan
     * @param cashOrderId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectMonthReportByCashOrderIds(List<Long> cashOrderIds);

    /**
     *
     * updateRiskControlOperationName:(更新风控姓名). <br/>
     *
     * @author guyan
     * @param appId
     * @param curDate
     * @param riskControlOperationName
     * @return
     */
    DubboResult<Boolean> updateRiskControlOperationName(Long appId, Date curDate,String riskControlOperationName);

    List<AccountMonthReportDto> selectAllMonthBillByMediaId(ReqMonthBillDto param);

   List<AccountMonthReportDto> selectBillListByCreateMonth(ReqMonthBillDto param);

    /**
     * 查询媒体所有可提现月账单
     * 更新  :  增加预付款结算单状态过滤
     * @param mediaId
     * @param companyType
     * @return
     */
    List<AccountMonthReportDto> selectByMediaIdAndType(Long mediaId, Integer companyType);

    /**
     * 根据媒体id查询所有可提现账单，每次查1000条
     * @param mediaId   媒体id
     * @param idIndex   id下标
     * @return
     */
    List<AccountMonthReportDto> selectByMediaIdWithIdIndex(Long mediaId, Long idIndex);

    /**
     * 通过提现单查询对应的提现金额
     * 如果传入为null或长度为0的集合，则返回空的集合
     */
    List<SettlementCashOrderDto> selectSettlementAmountByCashOrderIds(List<Long> cashOrderIds);

    /**
     *
     * selectBillByCashOrderIds:(通过提现ids查询月账单). <br/>
     *
     * @author guyan
     * @param cashOrderIds
     * @return
     * @since JDK 1.6
     */
    List<AccountMonthReportDto> selectAllMonthReportByCashOrderIds(List<Long> cashOrderIds);

    /**
     * 通过appid和curdate查询月账单信息
     *
     * @param appId
     * @param currentDate
     * @return
     */
    List<SettledMonthReportRsp> selectDataByAppIdAndCurDate(Long appId, String currentDate);

    /**
     * 统计非0待结算月账单数
     * @param mediaId 媒体用户Id
     * @param currentDate 月账单日期 eg: 2018-07
     * @return 对应的数量
     */
    int countFeiLingWaitCheck(Long mediaId, String currentDate);

    PageResultDto<AccountMonthReportDto> selectAccountMonthReportDtoToPage(ReqMonthBillDto reqMonthBillDto);

    /**
     * 填充0元月账单
     * @param dto
     * @return
     */
    List<Long> batchInsertNoMonthlyBillFilling(List<NoMonthlyBillFillingDto> dto);

    Boolean updatePrePayInfo(Long appId, Date settledDate, Integer prePayApp, Long prePayBalance, String prePayVoucher);
}
