package cn.com.duiba.tuia.ssp.center.api.constant.dmp;

import java.util.Objects;

public enum UserChartTagEnum {
    UNDER_AGE("010210", "18岁以下（未成年）"),

    YOUTH_AGE("010211", "18-35岁（青年人）"),

    MIDDLE_AGE("010212", "35-45岁（中年人）"),

    MIDDLE_OLD_AGE("010213", "45-55岁（中老年人）"),
    OLD_AGE("010214", "55岁以上（老年人）"),
    MALE_CODE("010101","男"),
    FEMALE_CODE("010102","女"),
    NO_LIMIT_CODE("0","不限")


    ;

    private String code;
    private String desc;

    UserChartTagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static UserChartTagEnum getQueryType(String code){
        for (UserChartTagEnum e : values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }
        return null;
    }
}
