package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 运营商程序化媒体上报策略表
*/
@Data
public class OperatorMediaReportStrategyRspDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 主键
    */
    private Long id;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 积木ID
    */
    private String pageId;

    /**
    * 积木url
    */
    private String pageUrl;

    /**
    * 媒体ID
    */
    private Long appId;

    /**
    * 媒体名称
    */
    private String appName;

    /**
    * 平台ID
    */
    private Integer mediaPlatform;

    /**
    * 平台名称
    */
    private String platformName;

    /**
    * 账户ID
    */
    private String accountId;

    /**
    * 策略ID 1-多O概率上报 2-单资源概率上报 3-直接上报 4-固定收益上报 5-固定收益-自定义上报
    */
    private Integer strategyId;

    /**
    * 备注
    */
    private String remark;

    /**
    * 删除标识 0-否 1-是
    */
    private Integer isDeleted;

    /**
    * 扩展字段1
    */
    private String extendValue1;

    /**
    * 创建人ID
    */
    private Long createId;

    /**
    * 固定收益-单位（分）
    */
    private Long income;

    /**
    * 扩展字段2
    */
    private String extendValue2;

    /**
    * 运营商id tb_telecom_operator
    */
    private Long operatorId;

    private Integer pageType;

    private String industryName;

    private Long industryId;


}

