package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author yuquanfeng
 * @Date 2022/4/8
 * @Description
 * @Param
 * @return
 **/
@Data
public class ProgrammaticMediaReportStrategyDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private Long id;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtCreate;
    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtModified;
    /**
     * 删除标识 0-否 1-是
     */
    private Integer isDeleted;
    /**
     * 广告位ID
     */
    private Long slotId;
    /**
     * 广告位名称
     */
    private String slotName;
    /**
     * 媒体ID
     */
    private Long appId;
    /**
     * 媒体名称
     */
    private String appName;
    /**
     * 平台
     */
    private Integer mediaPlatform;
    /**
     * 平台名称
     */
    private String platformName;
    /**
     * 账户ID
     */
    private String accountId;
    /**
     * 策略ID 1-多O概率上报 2-单资源概率上报 3-直接上报
     */
    private Integer strategyId;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建人id
     */
    private Long createId;
    /**
     * 扩展字段 百度-token
     */
    private String extendValue;
    /**
     * 收益
     */
    private Long income;

    /**
     * 行业名称
     */
    private String industryName;
    /**
     * 行业id
     */
    private Integer industry;

    /**
     * 高签分层优先上报
     * 0-否 1-是
     */
    private Integer signPriorityReport;
}
