package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author yuantong
 * @version 1.0
 * @since 2020-02-17 10:13
 */
@Data
public class ReqAppMediaAvgUvStatistics implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 7964975683391052338L;

    /** 媒体ID */
    private List<Long> appIds;

    /** The start date. */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String startDate;

    /** The end date. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String endDate;

}
