package cn.com.duiba.tuia.ssp.center.api.dto.slotproportioncheck;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;
import cn.com.duiba.tuia.ssp.center.api.tool.DataMathUtil;

import java.util.List;

/**
* 广告位分成比例审核表
*/
public class SlotProportionCheckDto extends BaseDto {

    /**
     * 序列号
     */
    private static final long serialVersionUID = -8344461901058041476L;


    /**
    * 媒体ID
    */
    private Long appId;

    /**
    * 媒体名称
    */
    private String appName;

    /**
    * 广告位ID
    */
    private Long slotId;

    /**
    * 默认分成比例
    */
    private Integer initProportion;

    /**
    * 申请分成比例
    */
    private Integer applyProportion;

    /**
    * 审核人ID
    */
    private Long reviewerId;

    /**
    * 审核状态：0-未审核 1-审核中 2-审核通过 3-审核拒绝
    */
    private Integer checkStatus;

    /**
    * 审核拒绝原因
    */
    private String checkReason;

    /**
    * 0：未强制审核通过 1：强制审核通过
    */
    private Integer mark;

    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;

    /**
     * 广告位Ids
     */
    private List<Long> slotIds;

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * 审核类型:0-今日计费列表，1-今日需调整分成列表
     */
    private Integer updateType;


    public SlotProportionCheckDto() {

    }

    public SlotProportionCheckDto(Long appId, String appName, Long slotId, Integer initProportion, Integer applyProportion, Long reviewerId, String checkReason, Integer updateType) {
        this.appId = appId;
        this.appName = appName;
        this.slotId = slotId;
        this.initProportion = initProportion;
        this.applyProportion = applyProportion;
        this.reviewerId = reviewerId;
        this.checkReason = checkReason;
        this.updateType = updateType;
    }

    public Integer getUpdateType() {
        return updateType;
    }

    public void setUpdateType(Integer updateType) {
        this.updateType = updateType;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return appName;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setInitProportion(Integer initProportion) {
        this.initProportion = initProportion;
    }

    public Integer getInitProportion() {
        return initProportion;
    }

    public void setApplyProportion(Integer applyProportion) {
        this.applyProportion = applyProportion;
    }

    public Integer getApplyProportion() {
        return applyProportion;
    }

    public Long getReviewerId() {
        return reviewerId;
    }

    public void setReviewerId(Long reviewerId) {
        this.reviewerId = reviewerId;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckReason(String checkReason) {
        this.checkReason = checkReason;
    }

    public String getCheckReason() {
        return checkReason;
    }

    public void setMark(Integer mark) {
        this.mark = mark;
    }

    public Integer getMark() {
        return mark;
    }

    /**
     * 计算比例P=媒体合理收入/昨日广告消耗
     * @param logicalConsume 媒体合理收入
     * @param adConsume 昨日广告消耗
     * @return
     */
    public static Long getSplitRatioP(Long logicalConsume,Long adConsume){
        DataMathUtil instance = DataMathUtil.getInstance();
        return instance.calculateDivide(logicalConsume,adConsume,DataMathUtil.SCALE.SCALE_NUM0.getNum(),10000);

    }
}

