/**
 * Project Name:ssp-center-api
 * File Name:DeliveryType.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.constant
 * Date:2017年11月29日下午7:13:49
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * ClassName:DeliveryType <br/>
 * Function: 预付款审核状态. <br/>
 * Date:     2017年11月29日 下午7:13:49 <br/>
 * @author youhaijun
 * @version
 * @see
 */
public enum PrePayStatus {

    REJECT_STATUS(0, "审核拒绝", ""),
    OPERATION_CHECK(1, "待媒体运营审核", "媒体运营拒绝"),
    RISK_CHECK(2, "待风控审核", "风控拒绝"),
    MEDIA_CHARGE_MAN_CHECK(3, "待媒体负责人审核", "媒体负责人拒绝"),
    MEDIUM_CHARGE_MAN_CHECK(4, "待媒介负责人审核", "媒介负责人拒绝"),
    PRESIDENT_CHECK(5, "待总裁审核", "总裁审核拒绝"),
    REMIT_CHECK(6, "待财务审核", "财务审核拒绝"),
    WITHDRAW_DEPOSIT(7, "已打款", ""),
    WITHDRAW_DEPOSIT_DEDUCTED(8, "已打款", ""),
    REFUND(9, "已退款", ""),
    REFUND_DEDUCTED(10, "已退款", "");

    private Integer status;//状态码

    private String statusDesc;//审核状态描述
    private String rejectDesc;//拒绝描述


    PrePayStatus(Integer status, String statusDesc, String rejectDesc) {
        this.status = status;
        this.statusDesc = statusDesc;
        this.rejectDesc = rejectDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }

    public String getRejectDesc() {
        return rejectDesc;
    }

    public void setRejectDesc(String rejectDesc) {
        this.rejectDesc = rejectDesc;
    }

    public static PrePayStatus getEnum(Integer status) {
        for (PrePayStatus e : PrePayStatus.values()) {
            if (e.getStatus().equals(status)) {
                return e;
            }
        }
        return null;
    }
}

