package cn.com.duiba.tuia.ssp.center.api.constant.enums;

import lombok.Getter;
import org.apache.commons.lang.ObjectUtils;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2020/6/3
 * @description: 链接审核状态
 **/
public enum  MediaLinkCheckStatusEnum {

    TO_AUDIT( 0, "待审核"),
    PASS( 1, "已通过"),
    REFUSED( 2, "已拒绝"),
    ;

    MediaLinkCheckStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer getCodeByDesc(String desc) {
        for (MediaLinkCheckStatusEnum value : MediaLinkCheckStatusEnum.values()) {
            if (ObjectUtils.equals(value.getDesc(), desc)) {
                return value.code;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (MediaLinkCheckStatusEnum value : MediaLinkCheckStatusEnum.values()) {
            if (ObjectUtils.equals(value.getCode(), code)) {
                return value.desc;
            }
        }
        return null;
    }

    @Getter
    private Integer code;
    @Getter
    private String desc;
}
