/**
 * Project Name:ssp-center-api
 * File Name:ReqActivityDailyStatDataByPage.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年9月1日上午11:12:34
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqActivityDailyStatDataByPage <br/>
 * Function: 活动每日数据. <br/>
 * Date:     2017年9月1日 上午11:12:34 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqActDailyStatDataByPage extends ReqPageQuery implements Serializable{

    /**序列号*/
    private static final long serialVersionUID = 8017256405186093960L;
  

    /** 活动ID */
    @ApiModelProperty(value = "活动ID", required = false)
    private Long              activityId;

    /** 开始日期. */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;

    /** 结束日期. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;
    
    /**活动名称*/
    @ApiModelProperty(value = "活动名称", required = false)
    private String         activityName;  
    
    /** 导出方式. */
    @ApiModelProperty(value = "导出方式", required = false)
    private Integer     exportType;//0是汇总，1是分日导出
    
    /**活动来源*/
    private Integer     resource;
    
    /**活动来源过渡resource*/
    private Integer     source;
    
    /**
     * 活动类型
     */
    @ApiModelProperty(value = "活动类型", required = false)
    private String            activityType;
    

    /**
     * Gets the activityId.
     *
     * @return the activityId
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * Sets the activityId.
     *
     * @param activityId the activityId
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * Gets the startDate.
     *
     * @return the startDate
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * Sets the startDate.
     *
     * @param startDate the startDate
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * Gets the endDate.
     *
     * @return the endDate
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * Sets the endDate.
     *
     * @param endDate the endDate
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
    
    public String getActivityName() {
        return activityName;
    }

    
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }
    
    public Integer getExportType() {
        return exportType;
    }

    
    public void setExportType(Integer exportType) {
        this.exportType = exportType;
    }
    
    public Integer getResource() {
        return resource;
    }

    
    public void setResource(Integer resource) {
        this.resource = resource;
    }
    
    public Integer getSource() {
        return source;
    }

    
    public void setSource(Integer source) {
        this.source = source;
    }
    
    public String getActivityType() {
        return activityType;
    }

    
    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}

