package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Function: RspActivityDto
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
public class RspActivityDto implements Serializable {

    private static final long serialVersionUID = -5464051068300788944L;

    /** 活动开启状态 */
    public static final int                   ACT_ENABLE       = 1;

    /** 活动关闭状态 */
    public static final int                   ACT_UNABLE       = 0;

    /** 活动已经定向给指定媒体 */
    public static final boolean               ACT_BINDED       = true;

    /** 活动未定向给指定媒体 */
    public static final boolean               ACT_UNBIND       = false;

    /** 开启定向媒体 */
    public static final int                   IS_DIRECTMEDIA   = 1;

    /** 关闭定向媒体 */
    public static final int                   NO_DIRECTMEDIA   = 0;

    /** 开启定向广告位 **/
    public static final int                   IS_DIRECT_SLOT   = 1;

    /** 关闭定向广告位 **/
    public static final int                   IS_NOT_DIRECT_SLOT = 0;

    /**屏蔽活动标签*/
    public static final int                   IS_SHIELD_ACT_TAG = 1;

    /**未屏蔽活动标签*/
    public static final int                   NO_SHIELD_ACT_TAG = 0;
    
    /**包含素材*/
    public static final int                   IS_INCOLUDE_MATERIAL=1;
    
    /**没有包含素材*/
    public static final int                   NO_INCOLUDE_MATERIAL =0;

    /** 活动ID */
    private Long                              id;

    /** 活动名称 */
    private String                            name;

    /** 活动类型 */
    private Integer                           type;

    /** 活动类型名称 */
    private String                            typeName;

    /** 兑吧活动状态 */
    private Integer                           activityStatus;

    /** 活动状态 */
    private String                            status;

    /** 广告位素材规格列表 */
    private List<Long>                        msIdList;

    /** 定向模式： 0仅投放定向列表，1优先投放定向列表 */
    private Integer                           directAdvertMode;

    /** 是否定向广告券 */
    private Integer                           isDirectAdvert;

    /** 是否定向媒体 */
    private Integer                           isDirectMedia;

    /** 是否定向广告位 */
    private Integer                           isDirectSlot;

    /**
     * 是否固定顺序广告：0=否、1=是
     */
    private Integer                           isFixedOrderAdvert;

    /** 活动是否与原生广告位匹配 */
    private Integer isFitSdk;

    /** 活动是否与原生广告位不匹配的原因 */
    private String notFitReason;

    /** 活动是否开启 */
    private Integer                           isEnable;

    /** 是否已发布活动计划 */
    private Integer                           isPublish;

    /** 规格内容列表 */
    private List<RspMaterialSpecificationDto> msList;

    /** 活动计划ID */
    private Long                              planId;

    /** 素材数量 */
    private Integer                           itemContentAmount;

    /** 该活动是否已经定向媒体 */
    private Boolean                           isBinded;

    /** 活动来源 0-兑吧活动 1-推啊活动 */
    private Integer                           source;

    /** 排序位置 */
    private Integer                           index;

    /** 活动连接 */
    private String                            activityUrl;

    /** 活动标签 */
    private String                            tag;

    /** 是否匹配行业标签 */
    private Integer                           isMatchTradeTag;

    /** 活动行业标签列表 */
    private List<TagLibraryDto>               activityTradeTagList;

    /** 屏蔽活动状态 */
    private Integer                           shieldActTagFlag;

    /** 活动描述 */
    private String                            description;

    /** 活动推广计划标题 */
    private String                            planTitle;

    /** 活动组id */
    private Long                              actGroupId;

    /** 活动投放状态 */
    private Integer                           outPutStatus;

    /** 活动组id */
    private String                            effectTime;

    /** 活动皮肤类型 */
    private String                            subType;

    /** 活动皮肤名称 */
    private String                            skinName;

    /** 此活动定向的媒体集合 */
    private List<Long>                        directAppIds;

    /** 此活动定向的广告位集合 */
    private List<Long>                        directSlotIds;

    /** 周期类型 */
    private Integer                           cronType;

    /** 周期表达式 */
    private String                            cronExpression;

    /** 周期时间 */
    private List<Integer>                     days;

    /** 开始投放时间 */
    private String                            startHours;

    /** 结束投放时间 */
    private String                            endHours;

    /** 周期活动开关 */
    private Integer                           cronStatus;

    /** 是否是海外活动 0正常 1海外 */
    private Integer                           overseas;
    
    /**是否包含素材 0未包含 1包含*/
    private Integer                           includeMaterial;

    /** 创建时间*/
    private Date gmtCreate;



    /**
     * 审核状态
     */
    private Integer auditState;

    /**
     * 审核消息
     */
    private String auditMsg;

    /**
     * 最后审核提交人
     */
    private Long lastManagerId;

    /**
     * 最后审核提交时间
     */
    private Date submitAuditTime;

    /**
     * 测试计划状态: 0-关闭 1-开启 2-结束
     */
    private Integer planStatus;

    /*
     * 活动测试计划ID
     */
    private Long actTestPlanId;

    /**
     * 活动测试类型 0-正常 1-测试活动
     */
    private Integer isTestActivityType;

    private Byte belongToGroup;

    /**
     * 是否支持增值 0-否 1-是
     */
    private Integer isEnc;


    /** 屏蔽活动皮肤状态 1-被当前广告位屏蔽 */
    private Integer shieldActSkinTagFlag;

    /**
     * 活动二级类型，区分自定义,直投页，原生
     */
    private Integer activitySecondType;

    /**
     * 预警文案
     */
    private String prewarningContent;

    /**
     * source.
     *
     * @return the source
     * @since JDK 1.6
     */
    public Integer getSource() {
        return source;
    }

    /**
     * source.
     *
     * @param source the source to set
     * @since JDK 1.6
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * isBinded.
     *
     * @return the isBinded
     * @since JDK 1.6
     */
    public Boolean getIsBinded() {
        return isBinded;
    }


    private Boolean  notice = false;

    public Boolean getNotice() {
        return notice;
    }

    public void setNotice(Boolean notice) {
        this.notice = notice;
    }
    /**
     * isBinded.
     *
     * @param isBinded the isBinded to set
     * @since JDK 1.6
     */
    public void setIsBinded(Boolean isBinded) {
        this.isBinded = isBinded;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Long> getMsIdList() {
        return msIdList;
    }

    public void setMsIdList(List<Long> msIdList) {
        this.msIdList = msIdList;
    }

    public Integer getDirectAdvertMode() {
        return directAdvertMode;
    }

    public void setDirectAdvertMode(Integer directAdvertMode) {
        this.directAdvertMode = directAdvertMode;
    }

    public Integer getIsDirectAdvert() {
        return isDirectAdvert;
    }

    public void setIsDirectAdvert(Integer isDirectAdvert) {
        this.isDirectAdvert = isDirectAdvert;
    }

    public Integer getIsDirectMedia() {
        return isDirectMedia;
    }

    public void setIsDirectMedia(Integer isDirectMedia) {
        this.isDirectMedia = isDirectMedia;
    }

    public Integer getIsDirectSlot() {
        return isDirectSlot;
    }

    public void setIsDirectSlot(Integer isDirectSlot) {
        this.isDirectSlot = isDirectSlot;
    }

    public Integer getIsFixedOrderAdvert() {
        return isFixedOrderAdvert;
    }

    public void setIsFixedOrderAdvert(Integer isFixedOrderAdvert) {
        this.isFixedOrderAdvert = isFixedOrderAdvert;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    public List<RspMaterialSpecificationDto> getMsList() {
        return msList;
    }

    public void setMsList(List<RspMaterialSpecificationDto> msList) {
        this.msList = msList;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Integer getItemContentAmount() {
        return itemContentAmount;
    }

    public void setItemContentAmount(Integer itemContentAmount) {
        this.itemContentAmount = itemContentAmount;
    }

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Integer getShieldActTagFlag() {
        return shieldActTagFlag;
    }

    public void setShieldActTagFlag(Integer shieldActTagFlag) {
        this.shieldActTagFlag = shieldActTagFlag;
    }

    public String getActivityUrl() {

        return activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPlanTitle() {
        return planTitle;
    }

    public void setPlanTitle(String planTitle) {
        this.planTitle = planTitle;
    }

	public Long getActGroupId() {
		return actGroupId;
	}

	public void setActGroupId(Long actGroupId) {
		this.actGroupId = actGroupId;
	}

	public Integer getOutPutStatus() {
		return outPutStatus;
	}

	public void setOutPutStatus(Integer outPutStatus) {
		this.outPutStatus = outPutStatus;
	}

	public String getEffectTime() {
		return effectTime;
	}

	public void setEffectTime(String effectTime) {
		this.effectTime = effectTime;
	}

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public List<Long> getDirectAppIds() {
        return directAppIds;
    }

    public void setDirectAppIds(List<Long> directAppIds) {
        this.directAppIds = directAppIds;
    }

    public List<Long> getDirectSlotIds() {
        return directSlotIds;
    }

    public void setDirectSlotIds(List<Long> directSlotIds) {
        this.directSlotIds = directSlotIds;
    }

    public Integer getCronType() {
        return cronType;
    }

    public void setCronType(Integer cronType) {
        this.cronType = cronType;
    }

    public List<Integer> getDays() {
        return days;
    }

    public void setDays(List<Integer> days) {
        this.days = days;
    }

    public String getStartHours() {
        return startHours;
    }

    public void setStartHours(String startHours) {
        this.startHours = startHours;
    }

    public String getEndHours() {
        return endHours;
    }

    public void setEndHours(String endHours) {
        this.endHours = endHours;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public Integer getCronStatus() {
        return cronStatus;
    }

    public void setCronStatus(Integer cronStatus) {
        this.cronStatus = cronStatus;
    }

    public Integer getOverseas() {
        return overseas;
    }

    public void setOverseas(Integer overseas) {
        this.overseas = overseas;
    }
    
    
    public Integer getIncludeMaterial() {
        return includeMaterial;
    }

    
    public void setIncludeMaterial(Integer includeMaterial) {
        this.includeMaterial = includeMaterial;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Integer getAuditState() {
        return auditState;
    }

    public void setAuditState(Integer auditState) {
        this.auditState = auditState;
    }

    public String getAuditMsg() {
        return auditMsg;
    }

    public void setAuditMsg(String auditMsg) {
        this.auditMsg = auditMsg;
    }

    public Long getLastManagerId() {
        return lastManagerId;
    }

    public void setLastManagerId(Long lastManagerId) {
        this.lastManagerId = lastManagerId;
    }

    public Date getSubmitAuditTime() {
        return submitAuditTime;
    }

    public void setSubmitAuditTime(Date submitAuditTime) {
        this.submitAuditTime = submitAuditTime;
    }

    public Integer getPlanStatus() {
        return planStatus;
    }

    public void setPlanStatus(Integer planStatus) {
        this.planStatus = planStatus;
    }

    public Long getActTestPlanId() {
        return actTestPlanId;
    }

    public void setActTestPlanId(Long actTestPlanId) {
        this.actTestPlanId = actTestPlanId;
    }

    public Integer getIsTestActivityType() {
        return isTestActivityType;
    }

    public void setIsTestActivityType(Integer isTestActivityType) {
        this.isTestActivityType = isTestActivityType;
    }

    public Integer getIsFitSdk() {
        return isFitSdk;
    }

    public void setIsFitSdk(final Integer isFitSdk) {
        this.isFitSdk = isFitSdk;
    }

    public String getNotFitReason() {
        return notFitReason;
    }

    public void setNotFitReason(final String notFitReason) {
        this.notFitReason = notFitReason;
    }

    public Integer getIsEnc() {
        return isEnc;
    }

    public void setIsEnc(Integer isEnc) {
        this.isEnc = isEnc;
    }

    public Byte getBelongToGroup() {
        return belongToGroup;
    }

    public void setBelongToGroup(final Byte belongToGroup) {
        this.belongToGroup = belongToGroup;
    }

    public Integer getShieldActSkinTagFlag() {
        return shieldActSkinTagFlag;
    }

    public void setShieldActSkinTagFlag(Integer shieldActSkinTagFlag) {
        this.shieldActSkinTagFlag = shieldActSkinTagFlag;
    }

    public Integer getActivitySecondType() {
        return activitySecondType;
    }

    public void setActivitySecondType(Integer activitySecondType) {
        this.activitySecondType = activitySecondType;
    }

    public Integer getIsMatchTradeTag() {
        return isMatchTradeTag;
    }

    public void setIsMatchTradeTag(Integer isMatchTradeTag) {
        this.isMatchTradeTag = isMatchTradeTag;
    }

    public List<TagLibraryDto> getActivityTradeTagList() {
        return activityTradeTagList;
    }

    public void setActivityTradeTagList(List<TagLibraryDto> activityTradeTagList) {
        this.activityTradeTagList = activityTradeTagList;
    }

    public String getPrewarningContent() {
        return prewarningContent;
    }

    public void setPrewarningContent(String prewarningContent) {
        this.prewarningContent = prewarningContent;
    }
}
