package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 问题广告位活动操作
 *
 * @author zhangzhenghe
 * @since 2020-02-19 4:52 PM
 */
@Data
public class SlotActivityProblemsOperationDTO implements Serializable {

    private static final long serialVersionUID = -3441362130761041599L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 日期
     */
    private Date curDate;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 操作类型(1:删除活动 2:更换活动 3:流量占比调整)
     */
    private Integer operateType;

    /**
     * 被替换的活动id
     */
    private Long replaceActivityId;

    /**
     * 调整前流量占比
     */
    private Integer ratioBefore;

    /**
     * 调整后流量占比
     */
    private Integer ratioAfter;

    /**
     * 完成操作时间
     */
    private Date completeTime;

    /**
     * 是否完成操作(0:未完成 1:已完成)
     */
    private Integer completeType;
}
