package cn.com.duiba.tuia.ssp.center.api.dto.sdk;

import cn.com.duiba.tuia.ssp.center.api.annotation.FieldCheck;
import cn.com.duiba.tuia.ssp.center.api.tool.DateUtil;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
@Data
public class SdkCrashLogDTO implements Serializable {
    private Long id;

    @FieldCheck(notNull = true)
    @JSONField(name = "app_id")
    private Long appId;

    private String imei;

    private String idfa;

    private String oaid;

    @JSONField(name = "device_id")
    private String deviceId;

    @JSONField(name = "sdk_version")
    private String sdkVersion;

    @JSONField(name = "phone_brand")
    private String phoneBrand;

    @JSONField(name = "phone_model")
    private String phoneModel;

    // 系统版本
    @JSONField(name = "os_version")
    private String osVersion;

    // 系统型号
    @JSONField(name = "os_type")
    private String osType;

    // 包名
    @JSONField(name = "package_name")
    private String packageName;

    /**
     * 处理状态：1-已处理 2-未处理 3-不可处理 9-其他
     * {@link cn.com.duiba.tuia.ssp.center.api.constant.enums.SdkCrashLogStatusEnum}
     */
    @FieldCheck(notNull = true)
    private Integer status;

    // 崩溃日志
    @FieldCheck(notEmpty = true)
    @JSONField(name = "crash_logs")
    private String crashLogs;

    @JsonFormat(pattern = DateUtil.DEFAULT_FORMATTER, timezone = "GMT+8")
    private Date gmtCreate;

    @JsonFormat(pattern = DateUtil.DEFAULT_FORMATTER, timezone = "GMT+8")
    private Date gmtModified;

    // 补丁code
    private String patchCode;

    // 补丁版本
    private String patchVersion;

    /**
     * 日志类型，安卓sdk时必传，1=安卓sdk奔溃，2=oaid崩溃，3=其他奔溃类型
     */
    private Integer logType;

}