package cn.com.duiba.tuia.ssp.center.api.dto.slotActivityWayGroup;

import com.google.common.base.Objects;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author yuantong
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ReqSlotActivityWayGroup implements Serializable {

    private Long slotId;

    /** 地域类型ID */
    private Long regionId;

    /** 投放方式 */
    private Byte activityPutWay;

    // 活动组分流分配开关：关闭
    public static final int CLOSE_GROUP_FLOW = 0;
    // 活动组分流分配开关：打开
    public static final int OPEN_GROUP_FLOW = 1;

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ReqSlotActivityWayGroup that = (ReqSlotActivityWayGroup) o;
        return Objects.equal(slotId, that.slotId) &&
                Objects.equal(regionId, that.regionId) &&
                Objects.equal(activityPutWay, that.activityPutWay);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(slotId, regionId, activityPutWay);
    }
}