package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.BottomActivityDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;

/**
 * @Author yuquanfeng
 * @Date 2021/12/23
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteBottomActivityService {

    /**
     * 添加活动兜底策略
     * @param bottomActivityDTO
     * @return
     * @throws BizException
     */
    String addBottomActivityStrategy(BottomActivityDTO bottomActivityDTO) throws BizException;

    /**
     * 更新活动兜底策略
     * @param bottomActivityDTO
     * @return
     * @throws BizException
     */
    String updateBottomActivityStrategy(BottomActivityDTO bottomActivityDTO) throws BizException;

    /**
     * 分页查询活动兜底策略
     * @param bottomActivityDTO
     * @return
     */
    PageResultDto<BottomActivityDTO> queryByPage(BottomActivityDTO bottomActivityDTO);

    /**
     * 查询活动兜底策略详情
     * @param id
     * @return
     */
    BottomActivityDTO queryDetail(Long id);

    /**
     * 通过id删除
     * @param id 记录id
     * @return
     */
    Boolean deleteBottomActivityStrategy(Long id);

    /**
     * 当活动审核拒绝是发送消息
     * @param activityId
     * @param rejectReason
     */
    void sendMessageWhenActivityReviewReject(Long activityId, String rejectReason);

}
