package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaLinkCheckDTO;

import java.util.List;
import java.util.Set;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2020/6/3
 * @description: 落地页链接审核-广告用
 **/
@AdvancedFeignClient
public interface RemoteMediaLinkCheckService {

    /**
     * 查询媒体落地页链接审核开关状态
     * @param appId
     * @return
     */
    Boolean getMediaLinkCheckStatus(Long appId);

    /**
     * 推送审核链接
     * 广告
     * @param list
     */
    void pushMediaLink(List<MediaLinkCheckDTO> list);

    /**
     * 根据appId和审核状态查询审核链接
     * @param appId
     * @param checkStatus null则查询全部状态  @MediaLinkCheckStatusEnum
     * @return 落地页链接
     */
    Set<String> getMediaLinkByStatus(Long appId, Integer checkStatus);

    /**
     * 查询审核开关为开启状态的appId
     * @return
     */
    Set<Long> getAllAppIds();


}
