package cn.com.duiba.tuia.ssp.center.api.remote;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.List;

/**
 * 流量调整接口
 */
@AdvancedFeignClient
public interface RemoteSlotFlowService {

    /***
     * 查询长期流量调整列表
     */
    List<SlotFlowStableConfigDTO> listSlotFlowStableConfig(ReqSlotFlowStableConfig req);

    /***
     * 查询长期流量调整列表数目
     */
    int countSlotFlowStableConfig(ReqSlotFlowStableConfig req);

    /***
     * 编辑长期流量调整数据
     */
    Boolean updateSlotFlowStableConfig(ReqSlotFlowStableConfig req);

    /***
     * 查询今日流量调整列表
     */
    List<SlotFlowConfigDTO> listSlotFlowConfig(ReqSlotFlowConfig req);

    /***
     * 查询今日流量调整列表数目
     */
    int countSlotFlowConfig(ReqSlotFlowConfig req);

    /***
     * 编辑今日流量调整数据
     */
    Boolean updateSlotFlowConfig(ReqSlotFlowConfig req);

    /***
     * 查询流量调整记录列表
     */
    List<SlotFlowHistoryDTO> listSlotFlowHistory(Long appId);

}

