package cn.com.duiba.tuia.ssp.center.api.remote.dmp;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertDelCheckDto;
import cn.com.duiba.tuia.ssp.center.api.dto.dmp.AdvertAccountDto;
import cn.com.duiba.tuia.ssp.center.api.dto.dmp.CrowdDto;
import cn.com.duiba.tuia.ssp.center.api.params.dmp.CrowdParms;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDmpManagerService {
    Long  saveCrowdInfos(CrowdParms form) throws Exception;
    Integer editCrowdInfos(CrowdParms form);
    Integer deleteCrowdInfos(Long crowdId);
    List<Long> deleteCrowds(List<Long> crowdIds);
    Integer pushCrowds(List<Long> crowdIds);
    Map<String, Object> queryCrowdList(CrowdParms form);

    CrowdDto queryCrowdBeforeEdit(Long crowdId);
    CrowdDto queryDetail(Long crowdId);
    AdvertAccountDto querynamebyid(Long advertId , Long accountId);
    CrowdDto querySingleCrowds(Long crowdId, Long adminId, Integer validState);

    /**
     * 人群包是否能够删除(人群包是否被使用)
     */
    List<AdvertDelCheckDto> isDelete(List<Long> ids);
    /**
     * 人群包文件追加
     */
    void crowdUrlAppend(Long crowdId, Integer dataType, List<String> urls, Integer isAutoPush);

    /**
     * 账户下名称是否重复
     */
    boolean isDuplicateName(Long crowdId, Long adminId, String crowdName);

}
