package cn.com.duiba.tuia.ssp.center.api.remote.sdk;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkPatchDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkRecordDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkReleaseDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkVerifyRecordDTO;
import cn.com.duiba.tuia.ssp.center.api.params.SdkVerifyRecordParam;

import java.util.List;


@AdvancedFeignClient
public interface RemoteTuiaSdkReleaseService {

    Boolean addRelease(TuiaSdkReleaseDTO dto) throws BizException;

    Boolean modRelease(TuiaSdkReleaseDTO dto) throws BizException;

    Boolean modReleaseStatus(TuiaSdkReleaseDTO dto) throws BizException;

    TuiaSdkReleaseDTO getById(Long id);

    PageResultDto<TuiaSdkReleaseDTO> findByPage(Integer pageSize, Integer currentPage);

    List<TuiaSdkReleaseDTO> findBySdkVersionCode(Long sdkVersionCode, Integer releaseType);
}
