package cn.com.duiba.tuia.ssp.center.api.constant.dmp;

/**
 * @author zhangzichen
 */

public enum DataUpdateFreEnum {
    EVERY_TIME(1, "EVERY_TIME", 0L, "每次"),
    EVERY_DAY(2, "EVERY_DAY", 86400L, "每日"),
    EVERY_WEEK(3, "EVERY_WEEK", 2592000L, "每月"),
    EVERY_YEAR(4, "EVERY_YEAR", 946080000L, "每年"),
    NOT_UPDATE(5, "NOT_UPDATE", -1L, "永不"),
    USER_DEFINED(6, "EVERY_YEAR", -1L, "自定义");
    private Integer type;

    private String code;

    /***
     * 有效时间  换算成了秒   帮数据开发存的字段
     */
    private Long expireTime;

    private String desc;

    /**
     * 自定义更新机制输入的时间，xx分钟
     */
    private Long dataUpdateTime;

    DataUpdateFreEnum(Integer type, String code, Long expireTime, String desc) {
        this.type = type;
        this.code = code;
        this.expireTime = expireTime;
        this.desc = desc;
    }

    public static DataUpdateFreEnum getEnumWithType(Integer type) {
        for (DataUpdateFreEnum e : DataUpdateFreEnum.values()) {
            if(e.getType().equals(type)){
                return e;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
